/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.vesseldetector;

import dev.murad.shipping.block.vesseldetector.VesselDetectorBlock;
import dev.murad.shipping.entity.custom.train.AbstractTrainCarEntity;
import dev.murad.shipping.entity.custom.vessel.VesselEntity;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class VesselDetectorTileEntity
extends BlockEntity {
    private static final int MAX_RANGE = 3;
    private int cooldown = 0;

    public VesselDetectorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntitiesTypes.VESSEL_DETECTOR.get(), pos, state);
    }

    private static boolean isValidBlock(BlockState state) {
        return state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_50016_) || state.m_204336_(BlockTags.f_13034_);
    }

    private static int getSearchLimit(BlockPos pos, Direction direction, Level level) {
        int i;
        for (i = 0; i < 3 && VesselDetectorTileEntity.isValidBlock(level.m_8055_(pos)); ++i) {
            pos = pos.m_142300_(direction);
        }
        return i;
    }

    private void checkForVessel() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)VesselDetectorBlock.FACING);
        boolean found = !this.f_58857_.m_6249_((Entity)null, VesselDetectorTileEntity.getSearchBox(this.m_58899_(), direction, this.f_58857_), e -> e instanceof VesselEntity || e instanceof AbstractTrainCarEntity).isEmpty();
        boolean previousPowered = (Boolean)this.m_58900_().m_61143_((Property)VesselDetectorBlock.POWERED);
        this.m_58900_().m_61124_((Property)VesselDetectorBlock.POWERED, (Comparable)Boolean.valueOf(found));
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)VesselDetectorBlock.POWERED, (Comparable)Boolean.valueOf(found)));
        if (found != previousPowered) {
            BlockPos neighbour = this.m_58899_().m_142300_(direction.m_122424_());
            Block block = this.m_58900_().m_60734_();
            this.f_58857_.m_46586_(neighbour, block, this.m_58899_());
            this.f_58857_.m_46590_(neighbour, block, direction);
        }
    }

    public static AABB getSearchBox(BlockPos pos, Direction direction, Level level) {
        int searchLimit = VesselDetectorTileEntity.getSearchLimit(pos.m_142300_(direction), direction, level);
        Direction.AxisDirection posNeg = direction.m_122421_();
        BlockPos start = posNeg == Direction.AxisDirection.POSITIVE ? pos.m_142300_(direction) : pos;
        int offX = direction.m_122429_() == 0 ? 1 : direction.m_122429_() * searchLimit;
        int offY = direction.m_122430_() == 0 ? 1 : direction.m_122430_() * searchLimit;
        int offZ = direction.m_122431_() == 0 ? 1 : direction.m_122431_() * searchLimit;
        BlockPos end = start.m_142082_(offX, offY, offZ);
        return new AABB(start, end);
    }

    public void serverTickInternal() {
        if (this.cooldown < 0) {
            this.cooldown = 10;
            this.checkForVessel();
        } else {
            --this.cooldown;
        }
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, VesselDetectorTileEntity e) {
        e.serverTickInternal();
    }
}

