/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class ModifierStatsBuilder {
    private boolean dirty = false;
    private final Map<IToolStat<?>, Object> map = new HashMap();
    private final Map<INumericToolStat<?>, Float> multipliers = new HashMap();

    public <B> void updateStat(IToolStat<?> stat, Consumer<B> consumer) {
        consumer.accept(this.map.computeIfAbsent(stat, IToolStat::makeBuilder));
        this.dirty = true;
    }

    private <T> void setStat(StatsNBT.Builder builder, IToolStat<T> stat, StatsNBT base) {
        if (this.map.containsKey(stat)) {
            builder.set(stat, stat.build(this.map.get(stat), base.get(stat)));
        } else {
            builder.set(stat, base.get(stat));
        }
    }

    public void multiplier(INumericToolStat<?> stat, double value) {
        this.multipliers.put(stat, Float.valueOf((float)((double)this.multipliers.getOrDefault(stat, Float.valueOf(1.0f)).floatValue() * value)));
    }

    private <T> void buildStat(StatsNBT.Builder builder, IToolStat<T> stat) {
        builder.set(stat, stat.build(this.map.get(stat), stat.getDefaultValue()));
    }

    public StatsNBT build(StatsNBT base, @Nullable Item filter) {
        if (!this.dirty) {
            return base;
        }
        StatsNBT.Builder builder = StatsNBT.builder();
        Set<IToolStat<?>> existing = base.getContainedStats();
        for (IToolStat<?> stat : existing) {
            this.setStat(builder, stat, base);
        }
        for (IToolStat<?> stat : this.map.keySet()) {
            if (existing.contains(stat) || filter != null && !stat.supports(filter)) continue;
            this.buildStat(builder, stat);
        }
        return builder.build();
    }

    public StatsNBT build(StatsNBT base) {
        return this.build(base, null);
    }

    public MultiplierNBT buildMultipliers(@Nullable Item filter) {
        MultiplierNBT.Builder builder = MultiplierNBT.builder();
        for (Map.Entry<INumericToolStat<?>, Float> entry : this.multipliers.entrySet()) {
            INumericToolStat<?> stat = entry.getKey();
            if (filter != null && !stat.supports(filter)) continue;
            builder.set(stat, entry.getValue().floatValue());
        }
        return builder.build();
    }

    public MultiplierNBT buildMultipliers() {
        return this.buildMultipliers(null);
    }

    private ModifierStatsBuilder() {
    }

    public static ModifierStatsBuilder builder() {
        return new ModifierStatsBuilder();
    }
}

