/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import slimeknights.tconstruct.library.tools.definition.IToolStatProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class ModifiableArmorMaterial
implements ArmorMaterial {
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    private final ResourceLocation name;
    private final ToolDefinition[] armorDefinitions;
    private final SoundEvent equipSound;

    public ModifiableArmorMaterial(ResourceLocation name, SoundEvent equipSound, ToolDefinition ... armorDefinitions) {
        this.name = name;
        this.equipSound = equipSound;
        if (armorDefinitions.length != 4) {
            throw new IllegalArgumentException("Must have an armor definition for each slot");
        }
        this.armorDefinitions = armorDefinitions;
    }

    @Nullable
    public ToolDefinition getArmorDefinition(ArmorSlotType slotType) {
        return this.armorDefinitions[slotType.getIndex()];
    }

    private float getStat(FloatToolStat toolStat, @Nullable ArmorSlotType slotType) {
        ToolDefinition toolDefinition = slotType == null ? null : this.getArmorDefinition(slotType);
        float defaultValue = toolStat.getDefaultValue().floatValue();
        if (toolDefinition == null) {
            return defaultValue;
        }
        ToolDefinitionData data = toolDefinition.getData();
        return data.getBaseStat(toolStat).floatValue() * data.getMultiplier(toolStat);
    }

    public String m_6082_() {
        return this.name.toString();
    }

    public ResourceLocation getNameLocation() {
        return this.name;
    }

    public int m_7366_(EquipmentSlot slotIn) {
        return (int)this.getStat(ToolStats.DURABILITY, ArmorSlotType.fromEquipment(slotIn));
    }

    public int m_7365_(EquipmentSlot slotIn) {
        return (int)this.getStat(ToolStats.ARMOR, ArmorSlotType.fromEquipment(slotIn));
    }

    public float m_6651_() {
        return this.getStat(ToolStats.ARMOR_TOUGHNESS, ArmorSlotType.CHESTPLATE);
    }

    public float m_6649_() {
        return this.getStat(ToolStats.KNOCKBACK_RESISTANCE, ArmorSlotType.CHESTPLATE);
    }

    public int m_6646_() {
        return 0;
    }

    public Ingredient m_6230_() {
        return Ingredient.f_43901_;
    }

    public static Builder builder(ResourceLocation name, ArmorSlotType ... slotTypes) {
        return new Builder(name, slotTypes);
    }

    public static Builder builder(ResourceLocation name) {
        return ModifiableArmorMaterial.builder(name, ArmorSlotType.values());
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public static class Builder {
        private final ResourceLocation name;
        private final ToolDefinition.Builder[] builders;
        private final ArmorSlotType[] slotTypes;
        private SoundEvent soundEvent = SoundEvents.f_11678_;

        protected Builder(ResourceLocation baseName, ArmorSlotType[] slotTypes) {
            this.name = baseName;
            this.builders = new ToolDefinition.Builder[4];
            this.slotTypes = slotTypes;
            for (ArmorSlotType slot : slotTypes) {
                this.builders[slot.getIndex()] = ToolDefinition.builder(new ResourceLocation(baseName.m_135827_(), baseName.m_135815_() + "_" + slot.m_7912_()));
            }
        }

        private ToolDefinition.Builder getBuilder(ArmorSlotType slotType) {
            ToolDefinition.Builder builder = this.builders[slotType.getIndex()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType + " for material " + this.name);
            }
            return builder;
        }

        public Builder set(ArmorSlotType slot, Consumer<ToolDefinition.Builder> builderConsumer) {
            builderConsumer.accept(this.getBuilder(slot));
            return this;
        }

        public Builder set(Consumer<ToolDefinition.Builder> builderConsumer) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.set(slotType, builderConsumer);
            }
            return this;
        }

        public Builder setStatsProvider(ArmorSlotType slot, IToolStatProvider statProvider) {
            this.getBuilder(slot).setStatsProvider(statProvider);
            return this;
        }

        public Builder setStatsProvider(IToolStatProvider statProvider) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.setStatsProvider(slotType, statProvider);
            }
            return this;
        }

        public Builder skipRegister() {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.getBuilder(slotType).skipRegister();
            }
            return this;
        }

        public ModifiableArmorMaterial build() {
            ToolDefinition[] toolDefinitions = new ToolDefinition[4];
            for (ArmorSlotType slotType : this.slotTypes) {
                toolDefinitions[slotType.getIndex()] = this.builders[slotType.getIndex()].build();
            }
            return new ModifiableArmorMaterial(this.name, this.soundEvent, toolDefinitions);
        }

        public Builder setSoundEvent(SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }
    }
}

