/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.blocks.TurnTableBlock;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class TurnTableBlockTile
extends BlockEntity {
    private int cooldown = 5;
    private boolean canRotate = false;
    public int cat = 0;

    public TurnTableBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.TURN_TABLE_TILE.get(), pos, state);
    }

    public void tryRotate() {
        this.canRotate = true;
        this.cooldown = TurnTableBlock.getPeriod(this.m_58900_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TurnTableBlockTile tile) {
        tile.cat = Math.max(tile.cat - 1, 0);
        if (tile.cooldown == 0) {
            BlockPos targetPos;
            boolean ccw;
            Direction dir = (Direction)state.m_61143_((Property)TurnTableBlock.FACING);
            boolean success = BlockUtils.tryRotatingBlock(dir, ccw = (Boolean)state.m_61143_((Property)TurnTableBlock.INVERTED) ^ state.m_61143_((Property)TurnTableBlock.FACING) == Direction.DOWN, targetPos = pos.m_142300_(dir), level, null).isPresent();
            if (success) {
                level.m_7696_(pos, state.m_60734_(), 0, 0);
                level.m_151555_(GameEvent.f_157792_, targetPos);
                level.m_5594_(null, targetPos, SoundEvents.f_12017_, SoundSource.BLOCKS, 1.0f, 0.6f);
            }
            tile.cooldown = TurnTableBlock.getPeriod(state);
            int power = (Integer)state.m_61143_((Property)TurnTableBlock.POWER);
            boolean bl = tile.canRotate = success && power != 0;
            if (power == 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)TurnTableBlock.ROTATING, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else if (tile.canRotate) {
            --tile.cooldown;
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cooldown = compound.m_128451_("Cooldown");
        this.canRotate = compound.m_128471_("CanRotate");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Cooldown", this.cooldown);
        compound.m_128379_("CanRotate", this.canRotate);
    }
}

