/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.config;

import com.abdelaziz.canary.common.config.Option;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CanaryConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"CanaryConfig");
    private final Map<String, Option> options = new HashMap<String, Option>();
    private final Set<Option> optionsWithDependencies = new ObjectLinkedOpenHashSet();

    private CanaryConfig() {
        this.addMixinRule("ai", true);
        this.addMixinRule("ai.pathing", true);
        this.addMixinRule("ai.poi", true);
        this.addMixinRule("ai.poi.tasks", true);
        this.addMixinRule("ai.raid", true);
        this.addMixinRule("ai.sensor", true);
        this.addMixinRule("ai.sensor.secondary_poi", true);
        this.addMixinRule("ai.task", true);
        this.addMixinRule("ai.task.goat_jump", true);
        this.addMixinRule("ai.task.launch", true);
        this.addMixinRule("ai.task.memory_change_counting", true);
        this.addMixinRule("ai.task.replace_streams", true);
        this.addMixinRule("alloc", true);
        this.addMixinRule("alloc.blockstate", true);
        this.addMixinRule("alloc.chunk_random", true);
        this.addMixinRule("alloc.chunk_ticking", true);
        this.addMixinRule("alloc.composter", true);
        this.addMixinRule("alloc.deep_passengers", true);
        this.addMixinRule("alloc.empty_chunk", true);
        this.addMixinRule("alloc.empty_iterator", true);
        this.addMixinRule("alloc.empty_list", true);
        this.addMixinRule("alloc.entity_tracker", true);
        this.addMixinRule("alloc.enum_values", true);
        this.addMixinRule("alloc.enum_values.living_entity", true);
        this.addMixinRule("alloc.enum_values.piston_block", true);
        this.addMixinRule("alloc.enum_values.piston_structure", true);
        this.addMixinRule("alloc.enum_values.redstone_wire", true);
        this.addMixinRule("alloc.explosion_behavior", true);
        this.addMixinRule("alloc.nbt", true);
        this.addMixinRule("block", true);
        this.addMixinRule("block.flatten_states", true);
        this.addMixinRule("block.moving_block_shapes", true);
        this.addMixinRule("block.redstone_wire", true);
        this.addMixinRule("cached_hashcode", true);
        this.addMixinRule("calc", true);
        this.addMixinRule("calc.if_else", true);
        this.addMixinRule("calc.if_else.block_entity", true);
        this.addMixinRule("calc.if_else.block_entity.can_place_item", true);
        this.addMixinRule("calc.if_else.block_entity.can_place_item.brewing_stand", true);
        this.addMixinRule("calc.if_else.block_entity.composter", true);
        this.addMixinRule("calc.if_else.block_entity.get_capability", true);
        this.addMixinRule("calc.if_else.block_entity.get_capability.brewing_stand", true);
        this.addMixinRule("calc.if_else.block_entity.get_capability.furnace", true);
        this.addMixinRule("calc.if_else.block_entity.get_slots_for_face", true);
        this.addMixinRule("calc.if_else.block_entity.get_slots_for_face.brewing_stand", true);
        this.addMixinRule("calc.if_else.block_entity.get_slots_for_face.furnace", true);
        this.addMixinRule("calc.if_else.entity", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.goat", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.horse", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.iron_golem", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.ocelot", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.player", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.tamable_animal", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.villager", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.warden", true);
        this.addMixinRule("calc.if_else.entity.handle_entity_event.wolf", true);
        this.addMixinRule("calc.if_else.player_slot", true);
        this.addMixinRule("calc.if_else.raid_odds", true);
        this.addMixinRule("chunk", true);
        this.addMixinRule("chunk.block_counting", true);
        this.addMixinRule("chunk.entity_class_groups", true);
        this.addMixinRule("chunk.no_locking", true);
        this.addMixinRule("chunk.no_validation", true);
        this.addMixinRule("chunk.palette", true);
        this.addMixinRule("chunk.serialization", true);
        this.addMixinRule("collections", true);
        this.addMixinRule("collections.attributes", true);
        this.addMixinRule("collections.block_entity_tickers", true);
        this.addMixinRule("collections.brain", true);
        this.addMixinRule("collections.entity_by_type", true);
        this.addMixinRule("collections.entity_filtering", true);
        this.addMixinRule("collections.entity_ticking", true);
        this.addMixinRule("collections.gamerules", true);
        this.addMixinRule("collections.goals", true);
        this.addMixinRule("collections.mob_spawning", true);
        this.addMixinRule("entity", true);
        this.addMixinRule("entity.collisions", true);
        this.addMixinRule("entity.collisions.intersection", true);
        this.addMixinRule("entity.collisions.movement", true);
        this.addMixinRule("entity.collisions.suffocation", true);
        this.addMixinRule("entity.collisions.unpushable_cramming", true);
        this.addMixinRule("entity.data_tracker", true);
        this.addMixinRule("entity.data_tracker.no_locks", true);
        this.addMixinRule("entity.data_tracker.use_arrays", true);
        this.addMixinRule("entity.fast_elytra_check", true);
        this.addMixinRule("entity.fast_hand_swing", true);
        this.addMixinRule("entity.fast_powder_snow_check", true);
        this.addMixinRule("entity.fast_retrieval", true);
        this.addMixinRule("entity.inactive_navigations", true);
        this.addMixinRule("entity.replace_entitytype_predicates", true);
        this.addMixinRule("entity.skip_equipment_change_check", true);
        this.addMixinRule("entity.skip_fire_check", true);
        this.addMixinRule("gen", true);
        this.addMixinRule("gen.cached_generator_settings", true);
        this.addMixinRule("gen.chunk_region", true);
        this.addMixinRule("item", true);
        this.addMixinRule("math", true);
        this.addMixinRule("math.fast_blockpos", true);
        this.addMixinRule("math.fast_util", true);
        this.addMixinRule("math.sine_lut", true);
        this.addMixinRule("profiler", true);
        this.addMixinRule("shapes", true);
        this.addMixinRule("shapes.blockstate_cache", true);
        this.addMixinRule("shapes.lazy_shape_context", true);
        this.addMixinRule("shapes.optimized_matching", true);
        this.addMixinRule("shapes.precompute_shape_arrays", true);
        this.addMixinRule("shapes.shape_merging", true);
        this.addMixinRule("shapes.specialized_shapes", true);
        this.addMixinRule("util", true);
        this.addMixinRule("util.block_tracking", true);
        this.addMixinRule("util.chunk_access", true);
        this.addMixinRule("util.world_border_listener", true);
        this.addMixinRule("world", true);
        this.addMixinRule("world.block_entity_ticking.support_cache", false);
        this.addMixinRule("world.block_entity_ticking.world_border", true);
        this.addMixinRule("world.chunk_access", true);
        this.addMixinRule("world.chunk_tickets", true);
        this.addMixinRule("world.combined_heightmap_update", true);
        this.addMixinRule("world.explosions", true);
        this.addMixinRule("world.inline_block_access", true);
        this.addMixinRule("world.inline_height", true);
        this.addMixinRule("world.player_chunk_tick", true);
        this.addMixinRule("world.tick_scheduler", true);
        this.addRuleDependency("entity.collisions.unpushable_cramming", "chunk.entity_class_groups", true);
        this.addRuleDependency("world.block_entity_ticking.world_border", "util.world_border_listener", true);
    }

    public static CanaryConfig load(File file) {
        CanaryConfig config = new CanaryConfig();
        if (file.exists()) {
            Properties props = new Properties();
            try (FileInputStream fin = new FileInputStream(file);){
                props.load(fin);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load config file", e);
            }
            config.readProperties(props);
        } else {
            try {
                CanaryConfig.writeDefaultConfig(file);
            }
            catch (IOException e) {
                LOGGER.warn("Could not write default configuration file", (Throwable)e);
            }
        }
        config.applyModOverrides();
        while (config.applyDependencies()) {
        }
        return config;
    }

    private void addRuleDependency(String rule, String dependency, boolean requiredValue) {
        String ruleOptionName = CanaryConfig.getMixinRuleName(rule);
        Option option = this.options.get(ruleOptionName);
        if (option == null) {
            LOGGER.error("Option {} for dependency '{} depends on {}={}' not found. Skipping.", (Object)rule, (Object)rule, (Object)dependency, (Object)requiredValue);
            return;
        }
        String dependencyOptionName = CanaryConfig.getMixinRuleName(dependency);
        Option dependencyOption = this.options.get(dependencyOptionName);
        if (dependencyOption == null) {
            LOGGER.error("Option {} for dependency '{} depends on {}={}' not found. Skipping.", (Object)dependency, (Object)rule, (Object)dependency, (Object)requiredValue);
            return;
        }
        option.addDependency(dependencyOption, requiredValue);
        this.optionsWithDependencies.add(option);
    }

    private void addMixinRule(String mixin, boolean enabled) {
        String name = CanaryConfig.getMixinRuleName(mixin);
        if (this.options.putIfAbsent(name, new Option(name, enabled, false)) != null) {
            throw new IllegalStateException("Mixin rule already defined: " + mixin);
        }
    }

    private void readProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            boolean enabled;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option option = this.options.get(key);
            if (option == null) {
                LOGGER.warn("No configuration key exists with name '{}', ignoring", (Object)key);
                continue;
            }
            if (value.equalsIgnoreCase("true")) {
                enabled = true;
            } else if (value.equalsIgnoreCase("false")) {
                enabled = false;
            } else {
                LOGGER.warn("Invalid value '{}' encountered for configuration key '{}', ignoring", (Object)value, (Object)key);
                continue;
            }
            option.setEnabled(enabled, true);
        }
    }

    private static void writeDefaultConfig(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write("# This is the configuration file for Canary.\n");
            writer.write("# This file exists for debugging purposes and should not be configured otherwise.\n");
            writer.write("# Before configuring anything, take a backup of the worlds that will be opened.\n");
            writer.write("#\n");
            writer.write("# You can find information on editing this file and all the available options here:\n");
            writer.write("# https://github.com/AbdElAziz333/Canary/wiki/Configuration-File\n");
            writer.write("#\n");
            writer.write("# By default, this file will be empty except for this notice.\n");
        }
    }

    private void applyModOverrides() {
        for (ModInfo mod : LoadingModList.get().getMods()) {
            String modid = mod.getModId();
            Path path = mod.getOwningFile().getFile().findResource(new String[]{"canary.overrides.properties"});
            if (!Files.exists(path, new LinkOption[0])) continue;
            Properties props = new Properties();
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                props.load(stream);
            }
            catch (IOException e) {
                LOGGER.warn("Could not load overrides file for mod '{}', ignoring", (Object)modid);
                continue;
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.applyModOverride(modid, entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    public Option getEffectiveOptionForMixin(String mixinClassName) {
        int nextSplit;
        int lastSplit = 0;
        Option rule = null;
        while ((nextSplit = mixinClassName.indexOf(46, lastSplit)) != -1) {
            String key = CanaryConfig.getMixinRuleName(mixinClassName.substring(0, nextSplit));
            Option candidate = this.options.get(key);
            if (candidate != null && !(rule = candidate).isEnabled()) {
                return rule;
            }
            lastSplit = nextSplit + 1;
        }
        return rule;
    }

    private boolean applyDependencies() {
        boolean changed = false;
        for (Option optionWithDependency : this.optionsWithDependencies) {
            changed |= optionWithDependency.disableIfDependenciesNotMet(LOGGER, this);
        }
        return changed;
    }

    private void applyModOverride(String modid, String name, String value) {
        Option option = this.options.get(name);
        if (option == null) {
            LOGGER.warn("Mod '{}' attempted to override option '{}', which doesn't exist, ignoring", (Object)modid, (Object)name);
            return;
        }
        boolean enabled = Boolean.parseBoolean(value);
        if (!value.equals(Boolean.toString(enabled))) {
            LOGGER.warn("Mod '{}' attempted to override option '{}' with an invalid value, ignoring", (Object)modid, (Object)name);
            return;
        }
        if (!enabled && option.isEnabled()) {
            option.clearModsDefiningValue();
        }
        if (!enabled || option.isEnabled() || option.getDefiningMods().isEmpty()) {
            option.addModOverride(enabled, modid);
        }
    }

    private static String getMixinRuleName(String name) {
        return "mixin." + name;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public int getOptionOverrideCount() {
        return (int)this.options.values().stream().filter(Option::isOverridden).count();
    }

    public Option getParent(Option option) {
        String optionName = option.getName();
        int split = optionName.lastIndexOf(46);
        if (split != -1) {
            String key = optionName.substring(0, split);
            return this.options.get(key);
        }
        return null;
    }
}

