/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.block;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.Materials;
import shetiphian.core.common.ToolHelper;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.common.block.HitBoxHelper;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class BlockEnderChest
extends BaseEntityBlock
implements IColored {
    public static final BooleanProperty STATIC = BooleanProperty.m_61465_((String)"static");
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])Direction.values());
    private static final EnumProperty<EnumType> VARIANT = EnumProperty.m_61587_((String)"variant", EnumType.class);
    public static final HashMap<Direction, VoxelShape[]> SHAPES = new HashMap();
    public static final HashMap<Direction, VoxelShape[]> SHAPES2 = new HashMap();

    public BlockEnderChest() {
        super(BlockBehaviour.Properties.m_60944_((Material)Materials.IMMOVABLE_TRANSLUCENT, (MaterialColor)MaterialColor.f_76365_).m_60913_(1.5f, 5.0f).m_60918_(SoundType.f_56742_).m_60960_((state, world, pos) -> false));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STATIC, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT, STATIC});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityEnderChest(pos, state);
    }

    private TileEntityEnderChest getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityEnderChest ? (TileEntityEnderChest)tile : null;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (SHAPES.isEmpty()) {
            Map<Direction, VoxelShape> chest_body = HitBoxHelper.getBody();
            Map<Direction, VoxelShape> chest_lid = HitBoxHelper.getLid();
            Map<Direction, VoxelShape> top_ring = HitBoxHelper.getRing_Top();
            Map<Direction, VoxelShape> middle_ring = HitBoxHelper.getRing_Middle();
            Map<Direction, VoxelShape> bottom_ring = HitBoxHelper.getRing_Bottom();
            for (Direction direction : Direction.values()) {
                VoxelShape[] shapes = new VoxelShape[]{chest_body.getOrDefault(direction, Shapes.m_83040_()), top_ring.getOrDefault(direction, Shapes.m_83040_()), middle_ring.getOrDefault(direction, Shapes.m_83040_()), bottom_ring.getOrDefault(direction, Shapes.m_83040_()), chest_lid.getOrDefault(direction, Shapes.m_83040_())};
                SHAPES.put(direction, shapes);
            }
        }
        if (!SHAPES.isEmpty()) {
            Direction direction = BlockEnderChest.getFacing(state);
            TileEntityEnderChest tile = this.getTile(world, pos);
            if (tile != null) {
                if (!SHAPES2.containsKey(direction)) {
                    VoxelShape base = SHAPES.get(direction)[0];
                    VoxelShape lid = SHAPES.get(direction)[4];
                    Vec3i vec = direction.m_122424_().m_122436_();
                    VoxelShape[] shapes = new VoxelShape[11];
                    shapes[0] = Shapes.m_83110_((VoxelShape)base, (VoxelShape)lid);
                    for (int index = 1; index <= 10; ++index) {
                        double var = (double)index / 10.0 * (double)0.7f;
                        shapes[index] = Shapes.m_83110_((VoxelShape)base, (VoxelShape)lid.m_83216_((double)vec.m_123341_() * var, (double)vec.m_123342_() * var, (double)vec.m_123343_() * var));
                    }
                    SHAPES2.put(direction, shapes);
                }
                return SHAPES2.get(direction)[tile.getLidOffsetIndex()];
            }
            return SHAPES.get(direction)[0];
        }
        return Shapes.m_83144_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.onBlockActivated(state, world, pos, player, player.m_21120_(hand));
    }

    public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos pos, Player player, ItemStack heldItem) {
        TileEntityEnderChest chestTile = this.getTile((BlockGetter)world, pos);
        if (chestTile == null) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6047_()) {
            if (heldItem.m_41619_() || !ToolHelper.isWrench((ItemStack)heldItem)) {
                BlockPos blockpos = pos.m_142300_(BlockEnderChest.getFacing(state).m_122424_());
                if (player instanceof ServerPlayer && chestTile.canUse(player) && !world.m_8055_(blockpos).m_60796_((BlockGetter)world, blockpos)) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ContainerProviders.EnderChest(chestTile), (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.m_41619_()) {
            DyeColor color;
            int subHit;
            if (chestTile.isPublic()) {
                boolean changed = false;
                if (Values.listPersonal.contains(heldItem.m_41720_())) {
                    if (((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalChests.get()).booleanValue()) {
                        changed = true;
                        chestTile.setOwner(player, heldItem.m_41777_().m_41620_(1));
                        Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(VARIANT, (Comparable)((Object)EnumType.PRIVATE))), (boolean)true);
                    } else {
                        ChestInfoHelper.sendError(player, "enderchests.chest.private.disabled");
                    }
                }
                if (!changed && Values.listTeam.contains(heldItem.m_41720_())) {
                    if (((Boolean)Configuration.ACCESS_SETTINGS.allowTeamChests.get()).booleanValue()) {
                        String teamID = Function.getPlayerTeamID((Player)player);
                        if (!Strings.isNullOrEmpty((String)teamID)) {
                            changed = true;
                            chestTile.setOwner(Function.getTeamDisplayName((String)teamID), "#" + teamID, heldItem.m_41777_().m_41620_(1));
                            Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(VARIANT, (Comparable)((Object)EnumType.TEAM))), (boolean)true);
                        } else {
                            ChestInfoHelper.sendError(player, "shetiphian.team.noteam");
                        }
                    } else {
                        ChestInfoHelper.sendError(player, "enderchests.chest.team.disabled");
                    }
                }
                if (changed) {
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (!chestTile.canEdit(player)) {
                return InteractionResult.SUCCESS;
            }
            short capacity = ChestHelper.getCapacity(world, chestTile.getOwnerID(), chestTile.getCode());
            if (capacity < (Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()) {
                int newValue = 0;
                if (Values.listSmallCap_Single.contains(heldItem.m_41720_())) {
                    newValue = -1;
                    if (chestTile.applyItem(heldItem)) {
                        newValue = 3;
                    } else if (!world.f_46443_) {
                        ChestInfoHelper.sendError(player, "enderchests.chest.upgrade_used");
                    }
                }
                if (newValue == 0 && Values.listSmallCap_Multi.contains(heldItem.m_41720_())) {
                    newValue = 3;
                }
                if (newValue == 0 && capacity + 9 <= (Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()) {
                    if (Values.listLargeCap_Single.contains(heldItem.m_41720_())) {
                        newValue = -1;
                        if (chestTile.applyItem(heldItem)) {
                            newValue = 9;
                        } else if (!world.f_46443_) {
                            ChestInfoHelper.sendError(player, "enderchests.chest.upgrade_used");
                        }
                    }
                    if (newValue == 0 && Values.listLargeCap_Multi.contains(heldItem.m_41720_())) {
                        newValue = 9;
                    }
                }
                if (newValue > 0) {
                    ChestHelper.setCapacity(world, chestTile.getOwnerID(), chestTile.getCode(), (byte)(capacity + newValue));
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    ChestInfoHelper.sendCapacityInfo(player, chestTile);
                    return InteractionResult.SUCCESS;
                }
            }
            if (((Boolean)Configuration.GENERAL.enableInWorldRecoloring.get()).booleanValue() && (subHit = Function.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])SHAPES.get(state.m_61143_((Property)FACING)))) > 0 && subHit < 4 && (color = DyeHelper.getDyeColor((Item)heldItem.m_41720_())) != null && chestTile.doColorRing(color, player)) {
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                world.m_46672_(pos, (Block)this);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? BlockEnderChest.m_152132_(type, Values.tileEnderChest, TileEntityEnderChest::tick) : null;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        return this.canHarvestBlock(state, world, pos, player) ? super.m_5880_(state, player, world, pos) : -1.0f;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityEnderChest tile = this.getTile((BlockGetter)world, pos);
        if (tile != null) {
            Object code = StackHelper.getCode(stack);
            while (((String)code).length() < 3) {
                code = "0" + (String)code;
            }
            ItemStack personalItem = StackHelper.getPersonalItem(stack);
            tile.setCode((String)code);
            if (!personalItem.m_41619_()) {
                tile.setOwner(StackHelper.getOwnerName(stack), StackHelper.getOwnerID(stack), personalItem);
                Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : EnumType.PRIVATE)))), (boolean)true);
            }
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        return tile == null || tile.canEdit(player);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.canHarvestBlock(state, (BlockGetter)world, pos, player) && super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        BlockEntity builderTile = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (builderTile instanceof TileEntityEnderChest) {
            ItemStack personal;
            TileEntityEnderChest tile = (TileEntityEnderChest)builderTile;
            Entity builderEntity = (Entity)builder.m_78982_(LootContextParams.f_81455_);
            if (builderEntity != null && builderEntity.m_6047_() && !(personal = tile.getPersonalItem()).m_41619_()) {
                drops.add(personal);
            }
        }
        return drops;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        if (tile != null) {
            return StackHelper.create(Item.m_41439_((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
        }
        return new ItemStack((ItemLike)this);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        if (tile != null) {
            if (player != null && !player.m_6047_()) {
                if (tile.isTeam() && (player.m_150110_().f_35937_ || tile.getOwnerID().equalsIgnoreCase("#" + Function.getPlayerTeamID((Player)player)))) {
                    return StackHelper.create(Item.m_41439_((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
                if (!tile.isPublic() && (player.m_150110_().f_35937_ || tile.getOwnerID().equalsIgnoreCase(player.m_142081_().toString()))) {
                    return StackHelper.create(Item.m_41439_((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
            }
            return StackHelper.create(Item.m_41439_((Block)this), tile.getCode(), null);
        }
        return new ItemStack((ItemLike)this);
    }

    public String m_7705_() {
        return "block.enderchests.chest.public";
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation != Rotation.NONE) {
            Direction facing = BlockEnderChest.getFacing(state);
            if (rotation == Rotation.CLOCKWISE_180) {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
            int value = facing.ordinal() + (rotation == Rotation.CLOCKWISE_90 ? 1 : -1);
            value = value < 0 ? 5 : (value > 5 ? 0 : value);
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.m_122376_((int)value));
        }
        return state;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return CapabilityHelper.COMPARATOR.getInputOverride((LevelAccessor)world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderChest tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile((BlockGetter)data.world, data.pos)) != null) {
            int value = Mth.m_14045_((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public static Direction getFacing(BlockState state) {
        Direction facing;
        try {
            facing = (Direction)state.m_61143_((Property)FACING);
        }
        catch (Exception e) {
            facing = Direction.DOWN;
            EnderChests.LOGGER.error("PropertyEnum 'BlockEnderChest.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + state);
        }
        return facing;
    }

    public static enum EnumType implements StringRepresentable
    {
        PUBLIC("public"),
        PRIVATE("private"),
        TEAM("team");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

