/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.turtlecharginstation.block.blockentity.custom;

import com.mikitellurium.turtlecharginstation.block.blockentity.ModBlockEntities;
import com.mikitellurium.turtlecharginstation.block.custom.TurtleChargingStationBlock;
import com.mikitellurium.turtlecharginstation.energy.ModEnergyStorage;
import com.mikitellurium.turtlecharginstation.gui.TurtleChargingStationMenu;
import com.mikitellurium.turtlecharginstation.networking.ModMessages;
import com.mikitellurium.turtlecharginstation.networking.packets.EnergySyncS2CPacket;
import com.mikitellurium.turtlecharginstation.networking.packets.TurtleFuelSyncS2CPacket;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurtleChargingStationBlockEntity
extends BlockEntity
implements MenuProvider {
    public static ForgeConfigSpec.IntValue CAPACITY;
    public static ForgeConfigSpec.IntValue CONVERSION_RATE;
    private final int maxReceive = (Integer)CONVERSION_RATE.get() * 6;
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage((Integer)CAPACITY.get(), this.maxReceive){

        @Override
        public void onEnergyChanged() {
            TurtleChargingStationBlockEntity.this.m_6596_();
            ModMessages.sendToClients(new EnergySyncS2CPacket(this.energy, TurtleChargingStationBlockEntity.this.m_58899_()));
        }
    };
    private final LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    private int extractCount = 6;
    private int textureTimer = 10;

    public TurtleChargingStationBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TURTLE_CHARGING_STATION.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TurtleChargingStationBlockEntity chargingStation) {
        if (level.f_46443_) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity be = level.m_7702_(chargingStation.f_58858_.m_142300_(direction));
            if (be == null) {
                --chargingStation.extractCount;
                continue;
            }
            if (be.m_58900_().m_60734_() == Registry.ModBlocks.TURTLE_NORMAL.get() || be.m_58900_().m_60734_() == Registry.ModBlocks.TURTLE_ADVANCED.get()) {
                if (chargingStation.ENERGY_STORAGE.getEnergyStored() >= (Integer)CONVERSION_RATE.get() && ((Boolean)chargingStation.m_58900_().m_61143_((Property)TurtleChargingStationBlock.ENABLED)).booleanValue()) {
                    TileTurtle turtle = (TileTurtle)be;
                    if (turtle.getAccess().getFuelLevel() == turtle.getAccess().getFuelLimit()) {
                        --chargingStation.extractCount;
                        continue;
                    }
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)TurtleChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(true)), 2);
                    TurtleChargingStationBlockEntity.refuelTurtle(chargingStation, turtle);
                    ++chargingStation.extractCount;
                    ModMessages.sendToClients(new TurtleFuelSyncS2CPacket(turtle.getAccess().getFuelLevel(), turtle.m_58899_()));
                    continue;
                }
                --chargingStation.extractCount;
                continue;
            }
            --chargingStation.extractCount;
        }
        if (chargingStation.extractCount <= 0) {
            if (--chargingStation.textureTimer <= 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)TurtleChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(false)), 2);
                chargingStation.textureTimer = 0;
            }
        } else {
            chargingStation.textureTimer = 10;
        }
        chargingStation.extractCount = 6;
    }

    private static void refuelTurtle(TurtleChargingStationBlockEntity chargingStation, TileTurtle turtle) {
        turtle.getAccess().addFuel(1);
        chargingStation.ENERGY_STORAGE.extractEnergy((Integer)CONVERSION_RATE.get(), false);
    }

    public EnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public void setClientEnergy(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new TurtleChargingStationMenu(id, inventory, this);
    }

    public Component m_5446_() {
        return new TextComponent("Turtle Charging Station");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.ENERGY_STORAGE.setEnergy(nbt.m_128451_("turtle_charger.energy"));
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("turtle_charger.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.m_183515_(nbt);
    }
}

