/*
 * Decompiled with CFR 0.152.
 */
package ca.edtoaster.littlecontraptions.ponder.element;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.element.AnimatedSceneElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VehicleElement<T extends Entity>
extends AnimatedSceneElement {
    private Vec3 location;
    private LerpedFloat rotation;
    private T entity;
    private EntityConstructor<T> constructor;
    private float initialRotation;

    public VehicleElement(Vec3 location, float rotation, EntityConstructor<T> constructor) {
        this.initialRotation = rotation;
        this.location = location.m_82520_(0.0, 0.0625, 0.0);
        this.constructor = constructor;
        this.rotation = LerpedFloat.angular().startWithValue((double)rotation);
    }

    public void reset(PonderScene scene) {
        super.reset(scene);
        this.entity.m_20343_(0.0, 0.0, 0.0);
        ((Entity)this.entity).f_19854_ = 0.0;
        ((Entity)this.entity).f_19855_ = 0.0;
        ((Entity)this.entity).f_19856_ = 0.0;
        ((Entity)this.entity).f_19790_ = 0.0;
        ((Entity)this.entity).f_19791_ = 0.0;
        ((Entity)this.entity).f_19792_ = 0.0;
        this.rotation.startWithValue((double)this.initialRotation);
    }

    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.constructor.create((Level)scene.getWorld(), 0.0, 0.0, 0.0);
        }
        ++((Entity)this.entity).f_19797_;
        this.entity.m_6853_(true);
        ((Entity)this.entity).f_19854_ = this.entity.m_20185_();
        ((Entity)this.entity).f_19855_ = this.entity.m_20186_();
        ((Entity)this.entity).f_19856_ = this.entity.m_20189_();
        ((Entity)this.entity).f_19790_ = this.entity.m_20185_();
        ((Entity)this.entity).f_19791_ = this.entity.m_20186_();
        ((Entity)this.entity).f_19792_ = this.entity.m_20189_();
    }

    public void setPositionOffset(Vec3 position, boolean immediate) {
        if (this.entity != null) {
            this.entity.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
            if (immediate) {
                ((Entity)this.entity).f_19854_ = position.f_82479_;
                ((Entity)this.entity).f_19855_ = position.f_82480_;
                ((Entity)this.entity).f_19856_ = position.f_82481_;
            }
        }
    }

    public void setRotation(float angle, boolean immediate) {
        if (this.entity != null) {
            this.rotation.setValue((double)angle);
            if (immediate) {
                this.rotation.startWithValue((double)angle);
            }
        }
    }

    public Vec3 getPositionOffset() {
        return this.entity != null ? this.entity.m_20182_() : Vec3.f_82478_;
    }

    public Vec3 getRotation() {
        return new Vec3(0.0, (double)this.rotation.getValue(), 0.0);
    }

    protected void renderLast(PonderWorld world, MultiBufferSource buffer, PoseStack ms, float fade, float pt) {
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        if (this.entity == null) {
            this.entity = this.constructor.create((Level)world, 0.0, 0.0, 0.0);
        }
        ms.m_85836_();
        ms.m_85837_(this.location.f_82479_, this.location.f_82480_, this.location.f_82481_);
        ms.m_85837_(Mth.m_14139_((double)pt, (double)((Entity)this.entity).f_19854_, (double)this.entity.m_20185_()), Mth.m_14139_((double)pt, (double)((Entity)this.entity).f_19855_, (double)this.entity.m_20186_()), Mth.m_14139_((double)pt, (double)((Entity)this.entity).f_19856_, (double)this.entity.m_20189_()));
        TransformStack.cast((PoseStack)ms).rotateY((double)this.rotation.getValue(pt));
        entityrenderermanager.m_114384_(this.entity, 0.0, 0.0, 0.0, 0.0f, pt, ms, buffer, this.lightCoordsFromFade(fade));
        ms.m_85849_();
    }

    public static interface EntityConstructor<T extends Entity> {
        public T create(Level var1, double var2, double var4, double var6);
    }
}

