/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.worldgen.AllPlacementModifiers;
import com.simibubi.create.infrastructure.worldgen.OreFeatureConfigEntry;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ConfigDrivenPlacement
extends PlacementModifier {
    public static final Codec<ConfigDrivenPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OreFeatureConfigEntry.CODEC.fieldOf("entry").forGetter(ConfigDrivenPlacement::getEntry)).apply((Applicative)instance, ConfigDrivenPlacement::new));
    private final OreFeatureConfigEntry entry;

    public ConfigDrivenPlacement(OreFeatureConfigEntry entry) {
        this.entry = entry;
    }

    public Stream<BlockPos> m_183381_(PlacementContext context, Random random, BlockPos pos) {
        int count = this.getCount(this.getFrequency(), random);
        if (count == 0) {
            return Stream.empty();
        }
        int minY = this.getMinY();
        int maxY = this.getMaxY();
        return IntStream.range(0, count).mapToObj(i -> pos).map(p -> {
            int x = random.nextInt(16) + p.m_123341_();
            int z = random.nextInt(16) + p.m_123343_();
            int y = Mth.m_144928_((Random)random, (int)minY, (int)maxY);
            return new BlockPos(x, y, z);
        });
    }

    public int getCount(float frequency, Random random) {
        int floored = Mth.m_14143_((float)frequency);
        return floored + (random.nextFloat() < frequency - (float)floored ? 1 : 0);
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)AllPlacementModifiers.CONFIG_DRIVEN.get();
    }

    public OreFeatureConfigEntry getEntry() {
        return this.entry;
    }

    public float getFrequency() {
        if (((Boolean)AllConfigs.common().worldGen.disable.get()).booleanValue()) {
            return 0.0f;
        }
        return this.entry.frequency.getF();
    }

    public int getMinY() {
        return (Integer)this.entry.minHeight.get();
    }

    public int getMaxY() {
        return (Integer)this.entry.maxHeight.get();
    }
}

