/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.roller;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.actors.roller.PaveTask;
import com.simibubi.create.content.contraptions.actors.roller.RollerActorInstance;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlock;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlockEntity;
import com.simibubi.create.content.contraptions.actors.roller.RollerRenderer;
import com.simibubi.create.content.contraptions.actors.roller.TrackPaverV2;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.trains.bogey.StandardBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class RollerMovementBehaviour
extends BlockBreakingMovementBehaviour {
    RollerTravellingPoint rollerScout = new RollerTravellingPoint();

    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !(context.contraption instanceof PulleyContraption) && VecHelper.isVecPointingTowards(context.relativeMotion, (Direction)context.state.m_61143_((Property)RollerBlock.f_54117_));
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new RollerActorInstance(materialManager, simulationWorld, context);
    }

    @Override
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffers) {
        if (!ContraptionRenderDispatcher.canInstance()) {
            RollerRenderer.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)RollerBlock.f_54117_)).m_122436_()).m_82490_(0.45).m_82492_(0.0, 2.0, 0.0);
    }

    @Override
    protected float getBlockBreakingSpeed(MovementContext context) {
        return Mth.m_14036_((float)(super.getBlockBreakingSpeed(context) * 1.5f), (float)0.0078125f, (float)16.0f);
    }

    @Override
    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        for (Direction side : Iterate.directions) {
            if (!world.m_8055_(breakingPos.m_142300_(side)).m_204336_(BlockTags.f_13075_)) continue;
            return false;
        }
        return super.canBreak(world, breakingPos, state) && !state.m_60812_((BlockGetter)world, breakingPos).m_83281_() && !AllBlocks.TRACK.has(state);
    }

    @Override
    protected DamageSource getDamageSource() {
        return RollerBlock.damageSourceRoller;
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level world = context.world;
        BlockState stateVisited = world.m_8055_(pos);
        if (!stateVisited.m_60796_((BlockGetter)world, pos)) {
            this.damageEntities(context, pos, world);
        }
        if (world.f_46443_) {
            return;
        }
        List<BlockPos> positionsToBreak = this.getPositionsToBreak(context, pos);
        if (positionsToBreak.isEmpty()) {
            this.triggerPaver(context, pos);
            return;
        }
        BlockPos argMax = null;
        double max = -1.0;
        for (BlockPos toBreak : positionsToBreak) {
            float hardness = context.world.m_8055_(toBreak).m_60800_((BlockGetter)world, toBreak);
            if ((double)hardness < max) continue;
            max = hardness;
            argMax = toBreak;
        }
        if (argMax == null) {
            this.triggerPaver(context, pos);
            return;
        }
        context.data.m_128365_("ReferencePos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        context.data.m_128365_("BreakingPos", (Tag)NbtUtils.m_129224_(argMax));
        context.stall = true;
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        super.onBlockBroken(context, pos, brokenState);
        if (!context.data.m_128441_("ReferencePos")) {
            return;
        }
        BlockPos referencePos = NbtUtils.m_129239_((CompoundTag)context.data.m_128469_("ReferencePos"));
        for (BlockPos otherPos : this.getPositionsToBreak(context, referencePos)) {
            if (otherPos.equals((Object)pos)) continue;
            this.destroyBlock(context, otherPos);
        }
        this.triggerPaver(context, referencePos);
        context.data.m_128473_("ReferencePos");
    }

    @Override
    protected void destroyBlock(MovementContext context, BlockPos breakingPos) {
        BlockState blockState = context.world.m_8055_(breakingPos);
        boolean noHarvest = blockState.m_204336_(BlockTags.f_144285_) || blockState.m_204336_(BlockTags.f_144286_) || blockState.m_204336_(BlockTags.f_144284_);
        BlockHelper.destroyBlock(context.world, breakingPos, 1.0f, stack -> {
            if (noHarvest || context.world.f_46441_.nextBoolean()) {
                return;
            }
            this.dropItem(context, (ItemStack)stack);
        });
        super.destroyBlock(context, breakingPos);
    }

    protected List<BlockPos> getPositionsToBreak(MovementContext context, BlockPos visitedPos) {
        PaveTask profileForTracks;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        RollerBlockEntity.RollingMode mode = this.getMode(context);
        if (mode != RollerBlockEntity.RollingMode.TUNNEL_PAVE) {
            return positions;
        }
        int startingY = 1;
        if (!this.getStateToPaveWith(context).m_60795_()) {
            ItemStack filter = ItemStack.m_41712_((CompoundTag)context.blockEntityData.m_128469_("Filter"));
            if (!ItemHelper.extract((IItemHandler)context.contraption.getSharedInventory(), stack -> FilterItem.test(context.world, stack, filter), 1, true).m_41619_()) {
                startingY = 0;
            }
        }
        if ((profileForTracks = this.createHeightProfileForTracks(context)) != null) {
            for (Couple<Integer> coords : profileForTracks.keys()) {
                boolean shouldPlaceSlab;
                float height = profileForTracks.get(coords);
                BlockPos targetPosition = new BlockPos((double)((Integer)coords.getFirst()).intValue(), (double)height, (double)((Integer)coords.getSecond()).intValue());
                boolean bl = shouldPlaceSlab = (double)height > Math.floor(height) + 0.45;
                if (startingY == 1 && shouldPlaceSlab && context.world.m_8055_(targetPosition.m_7494_()).m_61145_((Property)SlabBlock.f_56353_).orElse(SlabType.DOUBLE) == SlabType.BOTTOM) {
                    startingY = 2;
                }
                for (int i = startingY; i <= (shouldPlaceSlab ? 3 : 2); ++i) {
                    if (!this.testBreakerTarget(context, targetPosition.m_6630_(i), i)) continue;
                    positions.add(targetPosition.m_6630_(i));
                }
            }
            return positions;
        }
        for (int i = startingY; i <= 2; ++i) {
            if (!this.testBreakerTarget(context, visitedPos.m_6630_(i), i)) continue;
            positions.add(visitedPos.m_6630_(i));
        }
        return positions;
    }

    protected boolean testBreakerTarget(MovementContext context, BlockPos target, int columnY) {
        BlockState stateToPaveWith = this.getStateToPaveWith(context);
        BlockState stateToPaveWithAsSlab = this.getStateToPaveWithAsSlab(context);
        BlockState stateAbove = context.world.m_8055_(target);
        if (columnY == 0 && stateAbove.m_60713_(stateToPaveWith.m_60734_())) {
            return false;
        }
        if (stateToPaveWithAsSlab != null && columnY == 1 && stateAbove.m_60713_(stateToPaveWithAsSlab.m_60734_())) {
            return false;
        }
        return this.canBreak(context.world, target, stateAbove);
    }

    @Nullable
    protected PaveTask createHeightProfileForTracks(MovementContext context) {
        if (context.contraption == null) {
            return null;
        }
        AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = cce.getCarriage();
        if (carriage == null) {
            return null;
        }
        Train train = carriage.train;
        if (train == null || train.graph == null) {
            return null;
        }
        CarriageBogey mainBogey = (CarriageBogey)carriage.bogeys.getFirst();
        TravellingPoint point = mainBogey.trailing();
        this.rollerScout.node1 = point.node1;
        this.rollerScout.node2 = point.node2;
        this.rollerScout.edge = point.edge;
        this.rollerScout.position = point.position;
        Direction.Axis axis = Direction.Axis.X;
        StructureTemplate.StructureBlockInfo info = context.contraption.getBlocks().get(BlockPos.f_121853_);
        if (info != null && info.f_74676_.m_61138_((Property)StandardBogeyBlock.AXIS)) {
            axis = (Direction.Axis)info.f_74676_.m_61143_((Property)StandardBogeyBlock.AXIS);
        }
        Direction orientation = cce.getInitialOrientation();
        Direction rollerFacing = (Direction)context.state.m_61143_((Property)RollerBlock.f_54117_);
        int step = orientation.m_122421_().m_122540_();
        double widthWiseOffset = axis.m_7863_(-context.localPos.m_123343_(), 0, -context.localPos.m_123341_()) * step;
        double lengthWiseOffset = axis.m_7863_(-context.localPos.m_123341_(), 0, context.localPos.m_123343_()) * step - 1;
        if (rollerFacing == orientation.m_122427_()) {
            lengthWiseOffset += 1.0;
        }
        double distanceToTravel = 2.0;
        PaveTask heightProfile = new PaveTask(widthWiseOffset, widthWiseOffset);
        TravellingPoint.ITrackSelector steering = this.rollerScout.steer(TravellingPoint.SteerDirection.NONE, new Vec3(0.0, 1.0, 0.0));
        this.rollerScout.traversalCallback = (edge, coords) -> {};
        this.rollerScout.travel(train.graph, lengthWiseOffset + 1.0, steering);
        this.rollerScout.traversalCallback = (edge, coords) -> {
            if (edge == null) {
                return;
            }
            if (edge.isInterDimensional()) {
                return;
            }
            if (edge.node1.getLocation().dimension != context.world.m_46472_()) {
                return;
            }
            TrackPaverV2.pave(heightProfile, train.graph, edge, (Double)coords.getFirst(), (Double)coords.getSecond());
        };
        this.rollerScout.travel(train.graph, distanceToTravel, steering);
        for (Couple<Integer> entry : heightProfile.keys()) {
            heightProfile.put((Integer)entry.getFirst(), (Integer)entry.getSecond(), (float)context.localPos.m_123342_() + heightProfile.get(entry));
        }
        return heightProfile;
    }

    protected void triggerPaver(MovementContext context, BlockPos pos) {
        BlockState stateToPaveWith = this.getStateToPaveWith(context);
        BlockState stateToPaveWithAsSlab = this.getStateToPaveWithAsSlab(context);
        RollerBlockEntity.RollingMode mode = this.getMode(context);
        if (mode != RollerBlockEntity.RollingMode.TUNNEL_PAVE && stateToPaveWith.m_60795_()) {
            return;
        }
        Vec3 directionVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)RollerBlock.f_54117_)).m_122427_().m_122436_());
        directionVec = (Vec3)context.rotation.apply(directionVec);
        PaveResult paveResult = PaveResult.PASS;
        int yOffset = 0;
        ArrayList<Pair<BlockPos, Boolean>> paveSet = new ArrayList<Pair<BlockPos, Boolean>>();
        PaveTask profileForTracks = this.createHeightProfileForTracks(context);
        if (profileForTracks == null) {
            paveSet.add(Pair.of(pos, false));
        } else {
            for (Couple<Integer> coords : profileForTracks.keys()) {
                float f = profileForTracks.get(coords);
                boolean shouldPlaceSlab = (double)f > Math.floor(f) + 0.45;
                BlockPos blockPos = new BlockPos((double)((Integer)coords.getFirst()).intValue(), (double)f, (double)((Integer)coords.getSecond()).intValue());
                paveSet.add(Pair.of(blockPos, shouldPlaceSlab));
            }
        }
        if (paveSet.isEmpty()) {
            return;
        }
        while (paveResult == PaveResult.PASS) {
            boolean bl;
            if (yOffset > (Integer)AllConfigs.server().kinetics.rollerFillDepth.get()) {
                paveResult = PaveResult.FAIL;
                break;
            }
            HashSet<Pair<BlockPos, Boolean>> currentLayer = new HashSet<Pair<BlockPos, Boolean>>();
            if (mode == RollerBlockEntity.RollingMode.WIDE_FILL) {
                for (Pair pair : paveSet) {
                    int radius = (yOffset + 1) / 2;
                    for (int i = -radius; i <= radius; ++i) {
                        for (int j = -radius; j <= radius; ++j) {
                            if (BlockPos.f_121853_.m_123333_((Vec3i)new BlockPos(i, 0, j)) > radius) continue;
                            currentLayer.add(Pair.of(((BlockPos)pair.getFirst()).m_142082_(i, -yOffset, j), (Boolean)pair.getSecond()));
                        }
                    }
                }
            } else {
                for (Pair pair : paveSet) {
                    currentLayer.add(Pair.of(((BlockPos)pair.getFirst()).m_6625_(yOffset), (Boolean)pair.getSecond()));
                }
            }
            boolean completelyBlocked = true;
            boolean bl2 = false;
            for (Pair pair : currentLayer) {
                if (stateToPaveWithAsSlab != null && yOffset == 0 && ((Boolean)pair.getSecond()).booleanValue()) {
                    this.tryFill(context, ((BlockPos)pair.getFirst()).m_7494_(), stateToPaveWithAsSlab);
                }
                if ((paveResult = this.tryFill(context, (BlockPos)pair.getFirst(), stateToPaveWith)) != PaveResult.FAIL) {
                    completelyBlocked = false;
                }
                if (paveResult != PaveResult.SUCCESS) continue;
                bl = true;
            }
            if (bl) {
                paveResult = PaveResult.SUCCESS;
            } else if (!completelyBlocked || yOffset == 0) {
                paveResult = PaveResult.PASS;
            }
            if (paveResult == PaveResult.SUCCESS && stateToPaveWith.m_60734_() instanceof FallingBlock) {
                paveResult = PaveResult.PASS;
            }
            if (paveResult != PaveResult.PASS || mode == RollerBlockEntity.RollingMode.TUNNEL_PAVE) break;
            ++yOffset;
        }
        if (paveResult == PaveResult.SUCCESS) {
            context.data.m_128405_("WaitingTicks", 2);
            context.data.m_128365_("LastPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            context.stall = true;
        }
    }

    public static BlockState getStateToPaveWith(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            BlockState defaultBlockState = bi.m_40614_().m_49966_();
            if (defaultBlockState.m_61138_((Property)SlabBlock.f_56353_)) {
                defaultBlockState = (BlockState)defaultBlockState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return defaultBlockState;
        }
        return Blocks.f_50016_.m_49966_();
    }

    protected BlockState getStateToPaveWith(MovementContext context) {
        return RollerMovementBehaviour.getStateToPaveWith(ItemStack.m_41712_((CompoundTag)context.blockEntityData.m_128469_("Filter")));
    }

    protected BlockState getStateToPaveWithAsSlab(MovementContext context) {
        BlockState stateToPaveWith = this.getStateToPaveWith(context);
        if (stateToPaveWith.m_61138_((Property)SlabBlock.f_56353_)) {
            return (BlockState)stateToPaveWith.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
        }
        Block block = stateToPaveWith.m_60734_();
        if (block == null) {
            return null;
        }
        ResourceLocation rl = block.getRegistryName();
        String namespace = rl.m_135827_();
        String blockName = rl.m_135815_();
        int nameLength = blockName.length();
        ArrayList<CallSite> possibleSlabLocations = new ArrayList<CallSite>();
        possibleSlabLocations.add((CallSite)((Object)(blockName + "_slab")));
        if (blockName.endsWith("s") && nameLength > 1) {
            possibleSlabLocations.add((CallSite)((Object)(blockName.substring(0, nameLength - 1) + "_slab")));
        }
        if (blockName.endsWith("planks") && nameLength > 7) {
            possibleSlabLocations.add((CallSite)((Object)(blockName.substring(0, nameLength - 7) + "_slab")));
        }
        for (String string : possibleSlabLocations) {
            Optional<Block> result = ForgeRegistries.BLOCKS.getHolder(new ResourceLocation(namespace, string)).map(slabHolder -> (Block)slabHolder.m_203334_());
            if (result.isEmpty()) continue;
            return result.get().m_49966_();
        }
        return null;
    }

    protected RollerBlockEntity.RollingMode getMode(MovementContext context) {
        return RollerBlockEntity.RollingMode.values()[context.blockEntityData.m_128451_("ScrollValue")];
    }

    protected PaveResult tryFill(MovementContext context, BlockPos targetPos, BlockState toPlace) {
        Level level = context.world;
        if (!level.m_46749_(targetPos)) {
            return PaveResult.FAIL;
        }
        BlockState existing = level.m_8055_(targetPos);
        if (existing.m_60713_(toPlace.m_60734_())) {
            return PaveResult.PASS;
        }
        if (!(existing.m_204336_(BlockTags.f_13035_) || existing.m_60767_().m_76336_() || existing.m_60812_((BlockGetter)level, targetPos).m_83281_())) {
            return PaveResult.FAIL;
        }
        ItemStack filter = ItemStack.m_41712_((CompoundTag)context.blockEntityData.m_128469_("Filter"));
        ItemStack held = ItemHelper.extract((IItemHandler)context.contraption.getSharedInventory(), stack -> FilterItem.test(context.world, stack, filter), 1, false);
        if (held.m_41619_()) {
            return PaveResult.FAIL;
        }
        level.m_46597_(targetPos, toPlace);
        return PaveResult.SUCCESS;
    }

    private final class RollerTravellingPoint
    extends TravellingPoint {
        public BiConsumer<TrackEdge, Couple<Double>> traversalCallback;

        private RollerTravellingPoint() {
        }

        @Override
        protected Double edgeTraversedFrom(TrackGraph graph, boolean forward, TravellingPoint.IEdgePointListener edgePointListener, TravellingPoint.ITurnListener turnListener, double prevPos, double totalDistance) {
            double from = forward ? prevPos : this.position;
            double to = forward ? this.position : prevPos;
            this.traversalCallback.accept(this.edge, Couple.create(from, to));
            return super.edgeTraversedFrom(graph, forward, edgePointListener, turnListener, prevPos, totalDistance);
        }
    }

    private static enum PaveResult {
        FAIL,
        PASS,
        SUCCESS;

    }
}

