/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import com.google.common.base.Preconditions;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;

public final class CraftingRecipeUtil {
    private CraftingRecipeUtil() {
    }

    public static NonNullList<Ingredient> ensure3by3CraftingMatrix(Recipe<?> recipe) {
        NonNullList<Ingredient> ingredients = CraftingRecipeUtil.getIngredients(recipe);
        NonNullList expandedIngredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        Preconditions.checkArgument((ingredients.size() <= 9 ? 1 : 0) != 0);
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            int width = shapedRecipe.m_44220_();
            int height = shapedRecipe.m_44221_();
            Preconditions.checkArgument((width <= 3 && height <= 3 ? 1 : 0) != 0);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int source = w + h * width;
                    int target = w + h * 3;
                    Ingredient i = (Ingredient)ingredients.get(source);
                    expandedIngredients.set(target, (Object)i);
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                expandedIngredients.set(i, (Object)((Ingredient)ingredients.get(i)));
            }
        }
        return expandedIngredients;
    }

    private static NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        if (recipe instanceof UpgradeRecipe) {
            UpgradeRecipe upgradeRecipe = (UpgradeRecipe)recipe;
            NonNullList ingredients = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
            ingredients.set(0, (Object)upgradeRecipe.f_44518_);
            ingredients.set(1, (Object)upgradeRecipe.f_44519_);
            return ingredients;
        }
        return recipe.m_7527_();
    }
}

