/*
 * Decompiled with CFR 0.152.
 */
package appeng.thirdparty.codechicken.lib.model.pipeline.transformers;

import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.IPipelineElementFactory;
import appeng.thirdparty.codechicken.lib.model.pipeline.QuadTransformer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;

public class QuadCornerKicker
extends QuadTransformer {
    public static final IPipelineElementFactory<QuadCornerKicker> FACTORY = QuadCornerKicker::new;
    public static int[][] horizonals = new int[][]{{2, 3, 4, 5}, {2, 3, 4, 5}, {0, 1, 4, 5}, {0, 1, 4, 5}, {0, 1, 2, 3}, {0, 1, 2, 3}};
    private int mySide;
    private int facadeMask;
    private AABB box;
    private double thickness;

    QuadCornerKicker() {
    }

    public void setSide(int side) {
        this.mySide = side;
    }

    public void setFacadeMask(int mask) {
        this.facadeMask = mask;
    }

    public void setBox(AABB box) {
        this.box = box;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    @Override
    public boolean transform() {
        int side = this.quad.orientation.ordinal();
        if (side != this.mySide && side != (this.mySide ^ 1)) {
            for (int hoz : horizonals[this.mySide]) {
                if (side == hoz || side == (hoz ^ 1) || (this.facadeMask & 1 << hoz) == 0) continue;
                Corner corner = Corner.fromSides(this.mySide ^ 1, side, hoz);
                for (Quad.Vertex vertex : this.quad.vertices) {
                    float x = vertex.vec[0];
                    float y = vertex.vec[1];
                    float z = vertex.vec[2];
                    if (!QuadCornerKicker.epsComp(x, corner.pX(this.box)) || !QuadCornerKicker.epsComp(y, corner.pY(this.box)) || !QuadCornerKicker.epsComp(z, corner.pZ(this.box))) continue;
                    Vec3i vec = Direction.values()[hoz].m_122436_();
                    x = (float)((double)x - (double)vec.m_123341_() * this.thickness);
                    y = (float)((double)y - (double)vec.m_123342_() * this.thickness);
                    z = (float)((double)z - (double)vec.m_123343_() * this.thickness);
                    vertex.vec[0] = x;
                    vertex.vec[1] = y;
                    vertex.vec[2] = z;
                }
            }
        }
        return true;
    }

    public static enum Corner {
        MIN_X_MIN_Y_MIN_Z(Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.NEGATIVE),
        MIN_X_MIN_Y_MAX_Z(Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.POSITIVE),
        MIN_X_MAX_Y_MIN_Z(Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE),
        MIN_X_MAX_Y_MAX_Z(Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.POSITIVE, Direction.AxisDirection.POSITIVE),
        MAX_X_MIN_Y_MIN_Z(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.NEGATIVE),
        MAX_X_MIN_Y_MAX_Z(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE, Direction.AxisDirection.POSITIVE),
        MAX_X_MAX_Y_MIN_Z(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.POSITIVE, Direction.AxisDirection.NEGATIVE),
        MAX_X_MAX_Y_MAX_Z(Direction.AxisDirection.POSITIVE, Direction.AxisDirection.POSITIVE, Direction.AxisDirection.POSITIVE);

        private Direction.AxisDirection xAxis;
        private Direction.AxisDirection yAxis;
        private Direction.AxisDirection zAxis;
        private static final int[] sideMask;

        private Corner(Direction.AxisDirection xAxis, Direction.AxisDirection yAxis, Direction.AxisDirection zAxis) {
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.zAxis = zAxis;
        }

        public static Corner fromSides(int sideA, int sideB, int sideC) {
            return Corner.values()[sideMask[sideA] | sideMask[sideB] | sideMask[sideC]];
        }

        public float pX(AABB box) {
            return (float)(this.xAxis == Direction.AxisDirection.NEGATIVE ? box.f_82288_ : box.f_82291_);
        }

        public float pY(AABB box) {
            return (float)(this.yAxis == Direction.AxisDirection.NEGATIVE ? box.f_82289_ : box.f_82292_);
        }

        public float pZ(AABB box) {
            return (float)(this.zAxis == Direction.AxisDirection.NEGATIVE ? box.f_82290_ : box.f_82293_);
        }

        static {
            sideMask = new int[]{0, 2, 0, 1, 0, 4};
        }
    }
}

