/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.block.networking.CableBusBlock;
import appeng.block.paint.PaintSplotchesBlock;
import appeng.blockentity.misc.PaintSplotchesBlockEntity;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.misc.PaintBallItem;
import appeng.items.tools.powered.BlockRecolorer;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.cells.BasicCellHandler;
import appeng.me.cells.BasicCellInventory;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.PlayerSource;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ColorApplicatorItem
extends AEBasePoweredItem
implements IBasicCellItem,
IBlockTool,
IMouseWheelItem {
    private static final double POWER_PER_USE = 100.0;
    private static final Map<TagKey<Item>, AEColor> TAG_TO_COLOR = AEColor.VALID_COLORS.stream().collect(Collectors.toMap(aeColor -> ConventionTags.dye(aeColor.dye), Function.identity()));
    private static final BiMap<DyeColor, Item> VANILLA_DYES = EnumHashBiMap.create(DyeColor.class);
    private static final String TAG_COLOR = "color";

    public ColorApplicatorItem(Item.Properties props) {
        super(AEConfig.instance().getColorApplicatorBattery(), props);
    }

    @Override
    public double getChargeRate(ItemStack stack) {
        return 80.0 + 80.0 * (double)this.getUpgrades(stack).getInstalledUpgrades(AEItems.ENERGY_CARD);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack is = context.m_43722_();
        Direction side = context.m_43719_();
        Player p = context.m_43723_();
        if (p == null && level instanceof ServerLevel) {
            p = Platform.getPlayer((ServerLevel)level);
        }
        Block blk = level.m_8055_(pos).m_60734_();
        ItemStack paintBall = this.getColor(is);
        AEItemKey paintBallKey = AEItemKey.of(paintBall);
        PlayerSource source = new PlayerSource(p);
        StorageCell inv = StorageCells.getCellInventory(is, null);
        if (inv != null) {
            AEColor color;
            long extracted = inv.extract(paintBallKey, 1L, Actionable.SIMULATE, source);
            if (extracted > 0L) {
                paintBall = paintBall.m_41777_();
                paintBall.m_41764_(1);
            } else {
                paintBall = ItemStack.f_41583_;
            }
            if (p != null && !Platform.hasPermissions(new DimensionalBlockPos(level, pos), p)) {
                return InteractionResult.FAIL;
            }
            if (!paintBall.m_41619_() && paintBall.m_41720_() instanceof SnowballItem) {
                BlockEntity be = level.m_7702_(pos);
                if (p != null && be instanceof IColorableBlockEntity) {
                    IColorableBlockEntity colorableBlockEntity = (IColorableBlockEntity)be;
                    if (this.getAECurrentPower(is) > 100.0 && colorableBlockEntity.getColor() != AEColor.TRANSPARENT && colorableBlockEntity.recolourBlock(side, AEColor.TRANSPARENT, p)) {
                        this.consumeItem(is, paintBallKey, false);
                        return InteractionResult.m_19078_((boolean)level.m_5776_());
                    }
                }
                Block testBlk = level.m_8055_(pos.m_142300_(side)).m_60734_();
                BlockEntity painted = level.m_7702_(pos.m_142300_(side));
                if (this.getAECurrentPower(is) > 100.0 && testBlk instanceof PaintSplotchesBlock && painted instanceof PaintSplotchesBlockEntity) {
                    this.consumeItem(is, paintBallKey, false);
                    ((PaintSplotchesBlockEntity)painted).cleanSide(side.m_122424_());
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            } else if (!paintBall.m_41619_() && (color = this.getColorFromItem(paintBall)) != null && this.getAECurrentPower(is) > 100.0 && color != AEColor.TRANSPARENT && this.recolourBlock(blk, side, level, pos, color, p)) {
                this.consumeItem(is, paintBallKey, false);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        if (p != null && InteractionUtil.isInAlternateUseMode(p)) {
            this.cycleColors(is, paintBall, 1);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult m_6880_(ItemStack is, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Sheep sheep;
        ItemStack paintBall = this.getColor(is);
        AEColor paintBallColor = this.getColorFromItem(paintBall);
        if (paintBallColor != null && interactionTarget instanceof Sheep && (sheep = (Sheep)interactionTarget).m_6084_() && !sheep.m_29875_() && sheep.m_29874_() != paintBallColor.dye) {
            if (!player.f_19853_.f_46443_ && this.getAECurrentPower(is) > 100.0) {
                sheep.m_29855_(paintBallColor.dye);
                sheep.f_19853_.m_6269_(player, (Entity)sheep, SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.consumeItem(is, AEItemKey.of(paintBall), false);
            }
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public Component m_7626_(ItemStack is) {
        MutableComponent extra = GuiText.Empty.text();
        AEColor selected = this.getActiveColor(is);
        if (selected != null && Platform.isClient()) {
            extra = new TranslatableComponent(selected.translationKey);
        }
        return super.m_7626_(is).m_6881_().m_130946_(" - ").m_7220_((Component)extra);
    }

    public AEColor getActiveColor(ItemStack tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    public boolean consumeColor(ItemStack applicator, AEColor color, boolean simulate) {
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return false;
        }
        KeyCounter availableItems = inv.getAvailableStacks();
        AEItemKey paintItem = null;
        for (AEKey what : availableItems.keySet()) {
            AEItemKey itemKey;
            if (!(what instanceof AEItemKey) || this.getColorFromItem((itemKey = (AEItemKey)what).getItem()) != color) continue;
            paintItem = itemKey;
            break;
        }
        if (paintItem != null) {
            return this.consumeItem(applicator, paintItem, simulate);
        }
        return false;
    }

    public boolean consumeItem(ItemStack applicator, AEItemKey paintItem, boolean simulate) {
        boolean success;
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return false;
        }
        Actionable mode = simulate ? Actionable.SIMULATE : Actionable.MODULATE;
        boolean bl = success = inv.extract(paintItem, 1L, mode, new BaseActionSource()) >= 1L && this.extractAEPower(applicator, 100.0, mode) >= 100.0;
        if (success && !simulate && paintItem.matches(this.getColor(applicator)) && inv.getAvailableStacks().get(paintItem) == 0L) {
            this.setColor(applicator, ItemStack.f_41583_);
        }
        return success;
    }

    private AEColor getColorFromItem(ItemStack paintBall) {
        if (paintBall.m_41619_()) {
            return null;
        }
        return this.getColorFromItem(paintBall.m_41720_());
    }

    private AEColor getColorFromItem(Item paintBall) {
        if (paintBall instanceof SnowballItem) {
            return AEColor.TRANSPARENT;
        }
        if (paintBall instanceof PaintBallItem) {
            PaintBallItem ipb = (PaintBallItem)paintBall;
            return ipb.getColor();
        }
        DyeColor vanillaDye = (DyeColor)VANILLA_DYES.inverse().get((Object)paintBall);
        if (vanillaDye != null) {
            return AEColor.fromDye(vanillaDye);
        }
        for (Map.Entry<TagKey<Item>, AEColor> entry : TAG_TO_COLOR.entrySet()) {
            if (!paintBall.m_204114_().m_203656_(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public ItemStack getColor(ItemStack is) {
        CompoundTag color;
        ItemStack oldColor;
        CompoundTag c = is.m_41783_();
        if (c != null && c.m_128441_(TAG_COLOR) && !(oldColor = ItemStack.m_41712_((CompoundTag)(color = c.m_128469_(TAG_COLOR)))).m_41619_()) {
            return oldColor;
        }
        return this.findNextColor(is, ItemStack.f_41583_, 0);
    }

    private ItemStack findNextColor(ItemStack is, ItemStack anchor, int scrollOffset) {
        ItemStack newColor = ItemStack.f_41583_;
        StorageCell inv = StorageCells.getCellInventory(is, null);
        if (inv != null) {
            KeyCounter itemList = inv.getAvailableStacks();
            if (anchor.m_41619_()) {
                AEItemKey firstItem = itemList.getFirstKey(AEItemKey.class);
                if (firstItem != null) {
                    newColor = firstItem.toStack();
                }
            } else {
                LinkedList<AEItemKey> list = new LinkedList<AEItemKey>();
                for (Object2LongMap.Entry<AEKey> i : itemList) {
                    Object object = i.getKey();
                    if (!(object instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)object;
                    list.add(itemKey);
                }
                if (list.isEmpty()) {
                    return ItemStack.f_41583_;
                }
                list.sort(Comparator.comparingInt(a -> {
                    AEColor color = this.getColorFromItem(a.getItem());
                    return color != null ? color.ordinal() : Integer.MAX_VALUE;
                }));
                AEItemKey where = (AEItemKey)list.getFirst();
                AEColor anchorColor = this.getColorFromItem(anchor);
                for (int cycles = 1 + list.size(); cycles > 0 && this.getColorFromItem(where.getItem()) != anchorColor; --cycles) {
                    list.addLast((AEItemKey)list.removeFirst());
                    where = (AEItemKey)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((AEItemKey)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((AEItemKey)list.removeLast());
                }
                return ((AEItemKey)list.get(0)).toStack();
            }
        }
        if (!newColor.m_41619_()) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    private void setColor(ItemStack is, ItemStack newColor) {
        CompoundTag data = is.m_41784_();
        if (newColor.m_41619_()) {
            data.m_128473_(TAG_COLOR);
        } else {
            CompoundTag color = new CompoundTag();
            newColor.m_41739_(color);
            data.m_128365_(TAG_COLOR, (Tag)color);
        }
    }

    private boolean recolourBlock(Block blk, Direction side, Level level, BlockPos pos, AEColor newColor, @Nullable Player p) {
        IColorableBlockEntity ct;
        BlockEntity be;
        BlockState state = level.m_8055_(pos);
        Block recolored = BlockRecolorer.recolor(blk, newColor);
        if (recolored != blk) {
            BlockState newState = recolored.m_49966_();
            for (Property prop : newState.m_61147_()) {
                newState = ColorApplicatorItem.copyProp(state, newState, prop);
            }
            return level.m_46597_(pos, newState);
        }
        if (blk instanceof CableBusBlock) {
            CableBusBlock cableBusBlock = (CableBusBlock)blk;
            if (p != null) {
                return cableBusBlock.recolorBlock((BlockGetter)level, pos, side, newColor.dye, p);
            }
        }
        if ((be = level.m_7702_(pos)) instanceof IColorableBlockEntity && (ct = (IColorableBlockEntity)be).getColor() != newColor) {
            ct.recolourBlock(side, newColor, p);
            return true;
        }
        return false;
    }

    private static <T extends Comparable<T>> BlockState copyProp(BlockState oldState, BlockState newState, Property<T> prop) {
        if (newState.m_61138_(prop)) {
            return (BlockState)newState.m_61124_(prop, oldState.m_61143_(prop));
        }
        return newState;
    }

    public void cycleColors(ItemStack is, ItemStack paintBall, int i) {
        if (paintBall.m_41619_()) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return this.getCellTooltipImage(stack);
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, AEKey requestedAddition) {
        if (requestedAddition instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)requestedAddition;
            return this.getColorFromItem(itemKey.getItem()) == null;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public AEKeyType getKeyType() {
        return AEKeyType.items();
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem(is, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        int energyCards = upgrades.getInstalledUpgrades(AEItems.ENERGY_CARD);
        this.setAEMaxPowerMultiplier(stack, 1 + energyCards * 8);
    }

    @Override
    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create(AEItemKey.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.m_41784_().m_128461_("FuzzyMode");
        if (fz.isEmpty()) {
            return FuzzyMode.IGNORE_ALL;
        }
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.m_41784_().m_128359_("FuzzyMode", fzMode.name());
    }

    @Override
    public void onWheel(ItemStack is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (this.m_41389_(group)) {
            items.add((Object)ColorApplicatorItem.createFullColorApplicator());
        }
    }

    public static ItemStack createFullColorApplicator() {
        ColorApplicatorItem item = AEItems.COLOR_APPLICATOR.m_5456_();
        ItemStack applicator = new ItemStack((ItemLike)item);
        BasicCellInventory dyeStorage = BasicCellHandler.INSTANCE.getCellInventory(applicator, null);
        for (Item dyeItem : VANILLA_DYES.values()) {
            dyeStorage.insert(AEItemKey.of((ItemLike)dyeItem), 128L, Actionable.MODULATE, new BaseActionSource());
        }
        dyeStorage.insert(AEItemKey.of((ItemLike)Items.f_42452_), 128L, Actionable.MODULATE, new BaseActionSource());
        IUpgradeInventory upgrades = item.getUpgrades(applicator);
        upgrades.addItems(AEItems.ENERGY_CARD.stack());
        upgrades.addItems(AEItems.ENERGY_CARD.stack());
        item.injectAEPower(applicator, item.getAEMaxPower(applicator), Actionable.MODULATE);
        return applicator;
    }

    public boolean setActiveColor(ItemStack applicator, @Nullable AEColor color) {
        if (color == null) {
            this.setColor(applicator, ItemStack.f_41583_);
            return true;
        }
        StorageCell inv = StorageCells.getCellInventory(applicator, null);
        if (inv == null) {
            return false;
        }
        for (Object2LongMap.Entry<AEKey> entry : inv.getAvailableStacks()) {
            AEItemKey itemKey;
            Object object = entry.getKey();
            if (!(object instanceof AEItemKey) || this.getColorFromItem((itemKey = (AEItemKey)object).getItem()) != color) continue;
            this.setColor(applicator, itemKey.toStack());
            return true;
        }
        return false;
    }

    static {
        VANILLA_DYES.put((Object)DyeColor.WHITE, (Object)Items.f_42535_);
        VANILLA_DYES.put((Object)DyeColor.ORANGE, (Object)Items.f_42536_);
        VANILLA_DYES.put((Object)DyeColor.MAGENTA, (Object)Items.f_42537_);
        VANILLA_DYES.put((Object)DyeColor.LIGHT_BLUE, (Object)Items.f_42538_);
        VANILLA_DYES.put((Object)DyeColor.YELLOW, (Object)Items.f_42539_);
        VANILLA_DYES.put((Object)DyeColor.LIME, (Object)Items.f_42540_);
        VANILLA_DYES.put((Object)DyeColor.PINK, (Object)Items.f_42489_);
        VANILLA_DYES.put((Object)DyeColor.GRAY, (Object)Items.f_42490_);
        VANILLA_DYES.put((Object)DyeColor.LIGHT_GRAY, (Object)Items.f_42491_);
        VANILLA_DYES.put((Object)DyeColor.CYAN, (Object)Items.f_42492_);
        VANILLA_DYES.put((Object)DyeColor.PURPLE, (Object)Items.f_42493_);
        VANILLA_DYES.put((Object)DyeColor.BLUE, (Object)Items.f_42494_);
        VANILLA_DYES.put((Object)DyeColor.BROWN, (Object)Items.f_42495_);
        VANILLA_DYES.put((Object)DyeColor.GREEN, (Object)Items.f_42496_);
        VANILLA_DYES.put((Object)DyeColor.RED, (Object)Items.f_42497_);
        VANILLA_DYES.put((Object)DyeColor.BLACK, (Object)Items.f_42498_);
    }
}

