/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.core.AELog;
import com.mojang.serialization.Dynamic;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class FixupDimensionHook {
    private FixupDimensionHook() {
    }

    public static <T> void removeDimension(Dynamic<T> nbt) {
        Object object = nbt.getValue();
        if (!(object instanceof CompoundTag)) {
            AELog.warn("Failed to fixup spatial dimension: Not loading from NBT", new Object[0]);
            return;
        }
        CompoundTag compoundTag = (CompoundTag)object;
        if (!compoundTag.m_128425_("WorldGenSettings", 10)) {
            AELog.warn("Failed to fixup spatial dimension: Missing WorldGenSettings", new Object[0]);
            return;
        }
        CompoundTag worldGenSettings = compoundTag.m_128469_("WorldGenSettings");
        if (!worldGenSettings.m_128425_("dimensions", 10)) {
            AELog.warn("Failed to fixup spatial dimension: Missing WorldGenSettings.dimensions", new Object[0]);
            return;
        }
        CompoundTag dimensions = worldGenSettings.m_128469_("dimensions");
        if (dimensions.m_128441_("ae2:spatial_storage")) {
            dimensions.m_128473_("ae2:spatial_storage");
            AELog.debug("Removed AE2 spatial storage before DFU can 'fix' it", new Object[0]);
        } else {
            AELog.warn("AE2 spatial storage dimension missing. It will be re-added.", new Object[0]);
        }
    }

    public static <T> void addDimension(Dynamic<T> nbt) {
        Object object = nbt.getValue();
        if (!(object instanceof CompoundTag)) {
            AELog.warn("Failed to re-add spatial dimension: Not loading from NBT", new Object[0]);
            return;
        }
        CompoundTag worldGenSettings = (CompoundTag)object;
        if (!worldGenSettings.m_128425_("dimensions", 10)) {
            AELog.warn("Failed to re-add spatial dimension: Missing dimensions key", new Object[0]);
            return;
        }
        CompoundTag dimensions = worldGenSettings.m_128469_("dimensions");
        if (!dimensions.m_128441_("ae2:spatial_storage")) {
            AELog.debug("Re-adding spatial storage NBT to world generation settings", new Object[0]);
            CompoundTag spatialStorage = new CompoundTag();
            spatialStorage.m_128359_("type", "ae2:spatial_storage");
            CompoundTag generator = new CompoundTag();
            generator.m_128359_("type", "ae2:spatial_storage");
            spatialStorage.m_128365_("generator", (Tag)generator);
            dimensions.m_128365_("ae2:spatial_storage", (Tag)spatialStorage);
        }
    }
}

