/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.client.AEStackRendering;
import appeng.api.config.LockCraftingMode;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.core.localization.GuiText;
import appeng.core.localization.InGameTooltip;
import appeng.menu.implementations.PatternProviderMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.Nullable;

public class PatternProviderLockReason
implements ICompositeWidget {
    protected boolean visible = false;
    protected int x;
    protected int y;
    private final PatternProviderScreen screen;

    public PatternProviderLockReason(PatternProviderScreen screen) {
        this.screen = screen;
    }

    @Override
    public void setPosition(Point position) {
        this.x = position.getX();
        this.y = position.getY();
    }

    @Override
    public void setSize(int width, int height) {
    }

    @Override
    public Rect2i getBounds() {
        return new Rect2i(this.x, this.y, 126, 16);
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void drawForegroundLayer(PoseStack poseStack, int zIndex, Rect2i bounds, Point mouse) {
        MutableComponent lockStatusText;
        Icon icon;
        PatternProviderMenu menu = (PatternProviderMenu)this.screen.m_6262_();
        if (menu.getCraftingLockedReason() == LockCraftingMode.NONE) {
            icon = Icon.UNLOCKED;
            lockStatusText = GuiText.CraftingLockIsUnlocked.text().m_130940_(ChatFormatting.DARK_GREEN);
        } else {
            icon = Icon.LOCKED;
            lockStatusText = GuiText.CraftingLockIsLocked.text().m_130940_(ChatFormatting.DARK_RED);
        }
        icon.getBlitter().dest(this.x, this.y).blit(poseStack, zIndex);
        Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)lockStatusText, (float)(this.x + 15), (float)(this.y + 5), -1);
    }

    @Override
    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        PatternProviderMenu menu = (PatternProviderMenu)this.screen.m_6262_();
        MutableComponent tooltip = switch (menu.getCraftingLockedReason()) {
            default -> throw new IncompatibleClassChangeError();
            case LockCraftingMode.NONE -> null;
            case LockCraftingMode.LOCK_UNTIL_PULSE -> InGameTooltip.CraftingLockedUntilPulse.text();
            case LockCraftingMode.LOCK_WHILE_HIGH -> InGameTooltip.CraftingLockedByRedstoneSignal.text();
            case LockCraftingMode.LOCK_WHILE_LOW -> InGameTooltip.CraftingLockedByLackOfRedstoneSignal.text();
            case LockCraftingMode.LOCK_UNTIL_RESULT -> {
                TextComponent stackAmount;
                Component stackName;
                GenericStack stack = menu.getUnlockStack();
                if (stack != null) {
                    stackName = AEStackRendering.getDisplayName(stack.what());
                    stackAmount = new TextComponent(stack.what().formatAmount(stack.amount(), AmountFormat.FULL));
                } else {
                    stackName = new TextComponent("ERROR");
                    stackAmount = new TextComponent("ERROR");
                }
                yield InGameTooltip.CraftingLockedUntilResult.text(stackName, stackAmount);
            }
        };
        return tooltip != null ? new Tooltip(new Component[]{tooltip}) : null;
    }
}

