/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.event.ControllerEvent;
import com.mrcrayfish.controllable.event.GatherActionsEvent;
import com.mrcrayfish.controllable.event.GatherNavigationPointsEvent;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.GunButtonBindings;
import com.mrcrayfish.guns.client.handler.AimingHandler;
import com.mrcrayfish.guns.client.handler.ReloadHandler;
import com.mrcrayfish.guns.client.handler.ShootingHandler;
import com.mrcrayfish.guns.client.screen.WorkbenchScreen;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.attachment.impl.Scope;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.C2SMessageAttachments;
import com.mrcrayfish.guns.network.message.C2SMessageUnload;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ControllerHandler {
    private int reloadCounter = -1;

    @SubscribeEvent
    public void onButtonInput(ControllerEvent.ButtonInput event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (player != null && world != null && Minecraft.m_91087_().f_91080_ == null) {
            ItemStack heldItem = player.m_21205_();
            int button = event.getButton();
            if (button == GunButtonBindings.SHOOT.getButton()) {
                if (heldItem.m_41720_() instanceof GunItem) {
                    event.setCanceled(true);
                    if (event.getState()) {
                        ShootingHandler.get().fire((Player)player, heldItem);
                    }
                }
            } else if (button == GunButtonBindings.AIM.getButton()) {
                if (heldItem.m_41720_() instanceof GunItem) {
                    event.setCanceled(true);
                }
            } else if (button == GunButtonBindings.STEADY_AIM.getButton()) {
                if (heldItem.m_41720_() instanceof GunItem) {
                    event.setCanceled(true);
                }
            } else if (button == GunButtonBindings.RELOAD.getButton()) {
                if (heldItem.m_41720_() instanceof GunItem) {
                    event.setCanceled(true);
                    if (event.getState()) {
                        this.reloadCounter = 0;
                    }
                }
            } else if (button == GunButtonBindings.OPEN_ATTACHMENTS.getButton() && heldItem.m_41720_() instanceof GunItem && Minecraft.m_91087_().f_91080_ == null) {
                event.setCanceled(true);
                if (event.getState()) {
                    PacketHandler.getPlayChannel().sendToServer((Object)new C2SMessageAttachments());
                }
            }
        }
    }

    @SubscribeEvent
    public void onControllerTurn(ControllerEvent.Turn event) {
        ItemStack heldItem;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem && AimingHandler.get().isAiming()) {
            double adsSensitivity = (Double)Config.CLIENT.controls.aimDownSightSensitivity.get();
            event.setYawSpeed(10.0f * (float)adsSensitivity);
            event.setPitchSpeed(7.5f * (float)adsSensitivity);
            Scope scope = Gun.getScope(heldItem);
            if (scope != null && scope.isStable() && Controllable.isButtonPressed((int)GunButtonBindings.STEADY_AIM.getButton())) {
                event.setYawSpeed(event.getYawSpeed() / 2.0f);
                event.setPitchSpeed(event.getPitchSpeed() / 2.0f);
            }
        }
    }

    @SubscribeEvent
    public void updateAvailableActions(GatherActionsEvent event) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem) {
            Scope scope;
            event.getActions().put(GunButtonBindings.AIM, new Action((Component)new TranslatableComponent("cgm.action.aim"), Action.Side.RIGHT));
            event.getActions().put(GunButtonBindings.SHOOT, new Action((Component)new TranslatableComponent("cgm.action.shoot"), Action.Side.RIGHT));
            GunItem gunItem = (GunItem)heldItem.m_41720_();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            CompoundTag tag = heldItem.m_41783_();
            if (tag != null && tag.m_128451_("AmmoCount") < GunEnchantmentHelper.getAmmoCapacity(heldItem, modifiedGun)) {
                event.getActions().put(GunButtonBindings.RELOAD, new Action((Component)new TranslatableComponent("cgm.action.reload"), Action.Side.LEFT));
            }
            if ((scope = Gun.getScope(heldItem)) != null && scope.isStable() && AimingHandler.get().isAiming()) {
                event.getActions().put(GunButtonBindings.STEADY_AIM, new Action((Component)new TranslatableComponent("cgm.action.steady_aim"), Action.Side.RIGHT));
            }
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        Gun gun;
        ItemStack heldItem;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (Controllable.isButtonPressed((int)GunButtonBindings.SHOOT.getButton()) && Minecraft.m_91087_().f_91080_ == null && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem && (gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem)).getGeneral().isAuto()) {
            ShootingHandler.get().fire((Player)player, heldItem);
        }
        if (mc.f_91080_ == null && this.reloadCounter != -1 && Controllable.isButtonPressed((int)GunButtonBindings.RELOAD.getButton())) {
            ++this.reloadCounter;
        }
        if (this.reloadCounter > 40) {
            ReloadHandler.get().setReloading(false);
            PacketHandler.getPlayChannel().sendToServer((Object)new C2SMessageUnload());
            this.reloadCounter = -1;
        } else if (this.reloadCounter > 0 && !Controllable.isButtonPressed((int)GunButtonBindings.RELOAD.getButton())) {
            ReloadHandler.get().setReloading((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player) == false);
            this.reloadCounter = -1;
        }
    }

    public static boolean isAiming() {
        Controller controller = Controllable.getController();
        return controller != null && Controllable.isButtonPressed((int)GunButtonBindings.AIM.getButton());
    }

    public static boolean isShooting() {
        Controller controller = Controllable.getController();
        return controller != null && Controllable.isButtonPressed((int)GunButtonBindings.SHOOT.getButton());
    }

    @SubscribeEvent
    public void onGatherNavigationPoints(GatherNavigationPointsEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof WorkbenchScreen) {
            int i;
            WorkbenchScreen workbench = (WorkbenchScreen)mc.f_91080_;
            int startX = workbench.getGuiLeft();
            int startY = workbench.getGuiTop();
            for (i = 0; i < workbench.getTabs().size(); ++i) {
                int tabX = startX + 28 * i + 14;
                int tabY = startY - 14;
                event.addPoint((NavigationPoint)new BasicNavigationPoint((double)tabX, (double)tabY));
            }
            for (i = 0; i < 6; ++i) {
                int itemX = startX + 172 + 40;
                int itemY = startY + i * 19 + 63 + 9;
                event.addPoint((NavigationPoint)new BasicNavigationPoint((double)itemX, (double)itemY));
            }
        }
    }
}

