/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import com.mrcrayfish.framework.api.client.resources.IDataLoader;
import com.mrcrayfish.framework.api.client.resources.IResourceSupplier;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.guns.item.IMeta;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public final class MetaLoader
implements IDataLoader<ItemResource> {
    private static MetaLoader instance;
    private final Object2ObjectMap<Item, DataObject> itemToData = (Object2ObjectMap)Util.m_137469_((Object)new Object2ObjectOpenCustomHashMap(Util.m_137583_()), map -> map.defaultReturnValue((Object)DataObject.EMPTY));

    public static MetaLoader getInstance() {
        if (instance == null) {
            instance = new MetaLoader();
        }
        return instance;
    }

    private MetaLoader() {
    }

    public DataObject getData(Item item) {
        return (DataObject)this.itemToData.get((Object)item);
    }

    public List<ItemResource> getResourceSuppliers() {
        ArrayList<ItemResource> resources = new ArrayList<ItemResource>();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof IMeta).forEach(item -> {
            ResourceLocation key = item.m_204114_().m_205785_().m_135782_();
            ResourceLocation location = new ResourceLocation(key.m_135827_(), "models/item/" + key.m_135815_() + ".cgmmeta");
            resources.add(new ItemResource((Item)item, location));
        });
        return resources;
    }

    public void process(List<Pair<ItemResource, DataObject>> list) {
        this.itemToData.clear();
        list.forEach(pair -> {
            DataObject object = (DataObject)pair.getRight();
            if (!object.isEmpty()) {
                ItemResource resource = (ItemResource)pair.getLeft();
                this.itemToData.put((Object)resource.item(), (Object)object);
            }
        });
    }

    public boolean ignoreMissing() {
        return true;
    }

    public record ItemResource(Item item, ResourceLocation location) implements IResourceSupplier
    {
        public ResourceLocation getLocation() {
            return this.location;
        }
    }
}

