/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.panels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.util.cfg.entries.ConfigEntryCategory;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.panels.SolarPanelInstance;
import org.zeith.solarflux.panels.SolarPanels;

public class SolarPanel
implements ItemLike {
    private final SolarPanelData delegateDataBase;
    public final String name;
    public SolarPanelData delegateData;
    public SolarPanelData networkData;
    private String compatMod;
    public List<Consumer<RegisterRecipesEvent>> recipes = new ArrayList<Consumer<RegisterRecipesEvent>>();
    public final boolean isCustom;
    private SolarPanelBlock block;
    private LanguageData langs;

    public SolarPanel(String name, SolarPanelData data, boolean isCustom) {
        this.delegateDataBase = this.networkData = data;
        this.delegateData = this.networkData;
        this.name = (isCustom ? "custom_" : "") + name;
        this.isCustom = isCustom;
    }

    public SolarPanelData getPanelData() {
        return this.networkData != null ? this.networkData : this.delegateData;
    }

    public SolarPanel register() {
        if (SolarPanels.PANELS.containsKey(this.name)) {
            throw new IllegalArgumentException("Solar panel with id " + this.name + " already exists.");
        }
        SolarPanels.PANELS.put(this.name, this);
        return this;
    }

    public SolarPanel setCompatMod(String compatMod) {
        this.compatMod = compatMod;
        return this;
    }

    public String getCompatMod() {
        return this.compatMod;
    }

    public void configureBase(ConfigEntryCategory category) {
        this.delegateData = new SolarPanelData(category, this);
    }

    protected SolarPanelBlock createBlock() {
        return new SolarPanelBlock(this);
    }

    public SolarPanelBlock getBlock() {
        if (this.block == null) {
            this.block = this.createBlock();
            this.block.setRegistryName("sp_" + this.name);
        }
        return this.block;
    }

    public Supplier<Block> getBlockSupplier() {
        return () -> this.getBlock();
    }

    public Item m_5456_() {
        return this.getBlock().m_5456_();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder customBuilder() {
        Builder b = new Builder();
        b.custom = true;
        return b;
    }

    public LanguageData langBuilder() {
        return new LanguageData(this);
    }

    public boolean hasLang() {
        return this.langs != null;
    }

    public LanguageData getLang() {
        return this.langs;
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder(this);
    }

    public float computeSunIntensity(SolarPanelTile solar) {
        if (!solar.doesSeeSky()) {
            return 0.0f;
        }
        float celestialAngleRadians = solar.m_58904_().m_46490_(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplicator = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return Mth.m_14036_((float)(multiplicator * Mth.m_14089_((float)(celestialAngleRadians / displacement))), (float)0.0f, (float)1.0f);
    }

    public void recipes(RegisterRecipesEvent helper) {
        if (this.recipes != null) {
            this.recipes.forEach(c -> c.accept(helper));
        }
    }

    public SolarPanelInstance createInstance(SolarPanelTile tile) {
        SolarPanelInstance inst = new SolarPanelInstance();
        inst.delegate = this.name;
        inst.infoDelegate = this;
        inst.reset();
        return inst;
    }

    public void accept(SolarPanelInstance t) {
        SolarPanelData data = this.getPanelData();
        t.gen = data.generation;
        t.cap = data.capacity;
        t.transfer = data.transfer;
        t.delegate = this.name;
    }

    public static class SolarPanelData {
        public final long generation;
        public final long capacity;
        public final long transfer;
        public final float height;

        public SolarPanelData(FriendlyByteBuf buf) {
            this.generation = buf.readLong();
            this.capacity = buf.readLong();
            this.transfer = buf.readLong();
            this.height = buf.readFloat();
        }

        public SolarPanelData(long generation, long capacity, long transfer, float height) {
            this.generation = generation;
            this.capacity = capacity;
            this.transfer = transfer;
            this.height = height;
        }

        public SolarPanelData(ConfigEntryCategory cat, SolarPanel base) {
            this.generation = cat.getLongEntry("Generation Rate", base.delegateDataBase.generation, 1L, Long.MAX_VALUE).setDescription("How much FE does this solar panel produce per tick?").getValue();
            this.transfer = cat.getLongEntry("Transfer Rate", base.delegateDataBase.transfer, 1L, Long.MAX_VALUE).setDescription("How much FE does this solar panel emit to other blocks, per tick?").getValue();
            this.capacity = cat.getLongEntry("Capacity", base.delegateDataBase.capacity, 1L, Long.MAX_VALUE).setDescription("How much FE does this solar panel store?").getValue();
            this.height = cat.getFloatEntry("Height", base.delegateDataBase.height * 16.0f, 0.0f, 16.0f).setDescription("How high is this solar panel?").getValue().floatValue() / 16.0f;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeLong(this.generation);
            buf.writeLong(this.capacity);
            buf.writeLong(this.transfer);
            buf.writeFloat(this.height);
        }
    }

    public static class Builder {
        String name;
        Long generation;
        Long capacity;
        Long transfer;
        float height = 0.375f;
        boolean custom = false;

        public Builder name(String s) {
            this.name = s;
            return this;
        }

        public Builder height(float f) {
            this.height = f;
            return this;
        }

        public Builder generation(Number n) {
            this.generation = n.longValue();
            return this;
        }

        public Builder generation(String s) {
            this.generation = Long.parseLong(s);
            return this;
        }

        public Builder capacity(Number n) {
            this.capacity = n.longValue();
            return this;
        }

        public Builder capacity(String s) {
            this.capacity = Long.parseLong(s);
            return this;
        }

        public Builder transfer(Number n) {
            this.transfer = n.longValue();
            return this;
        }

        public Builder transfer(String s) {
            this.transfer = Long.parseLong(s);
            return this;
        }

        public SolarPanel build() {
            if (this.name == null) {
                throw new NullPointerException("name == null");
            }
            if (this.generation == null) {
                throw new NullPointerException("generation == null");
            }
            if (this.capacity == null) {
                throw new NullPointerException("capacity == null");
            }
            if (this.transfer == null) {
                throw new NullPointerException("transfer == null");
            }
            return new SolarPanel(this.name, new SolarPanelData(this.generation, this.capacity, this.transfer, this.height), this.custom);
        }

        public SolarPanel buildAndRegister() {
            return this.build().register();
        }
    }

    public static class LanguageData {
        public final Map<String, String> langToName = new HashMap<String, String>();
        public String def;
        final SolarPanel panel;

        public LanguageData(SolarPanel panel) {
            this.panel = panel;
        }

        public LanguageData put(String lang, String loc) {
            if ((lang = lang.toLowerCase()).equalsIgnoreCase("en_us")) {
                this.def = loc;
            }
            this.langToName.put(lang, loc);
            return this;
        }

        public String getName(String lang) {
            return this.langToName.getOrDefault(lang, this.def);
        }

        public SolarPanel build() {
            if (this.def == null) {
                throw new RuntimeException("Unable to apply languages: no 'en_us' value found!");
            }
            this.panel.langs = this;
            return this.panel;
        }
    }

    public static class RecipeBuilder {
        final SolarPanel panel;
        final List<Consumer<ShapedRecipeBuilder>> handlers = new ArrayList<Consumer<ShapedRecipeBuilder>>();

        public RecipeBuilder(SolarPanel panel) {
            this.panel = panel;
        }

        public RecipeBuilder shape(String ... strings) {
            this.handlers.add(b -> b.shape(strings));
            return this;
        }

        public RecipeBuilder bind(String ch, Object output) {
            if (ch.length() != 1) {
                throw new IllegalArgumentException(ch + " is not a single character!");
            }
            this.handlers.add(b -> b.map(ch.charAt(0), output));
            return this;
        }

        public SolarPanel build() {
            return this.build(1);
        }

        public SolarPanel build(int amount) {
            int lineNumber = Thread.currentThread().getStackTrace()[2].getLineNumber();
            this.panel.recipes.add(evt -> {
                ResourceLocation prn = this.panel.getBlock().getRegistryName();
                ShapedRecipeBuilder builder = (ShapedRecipeBuilder)((ShapedRecipeBuilder)evt.shaped().id(new ResourceLocation(prn.m_135827_(), "builtin/generated_" + prn.m_135815_() + "_x_" + amount + "_ln" + lineNumber))).result(new ItemStack((ItemLike)this.panel, amount));
                this.handlers.forEach(c -> c.accept(builder));
                builder.register();
            });
            return this.panel;
        }
    }
}

