/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.solarflux.attribute.SimpleAttributeProperty;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.container.SolarPanelContainer;
import org.zeith.solarflux.items.UpgradeItem;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarPanelInstance;
import org.zeith.solarflux.panels.SolarPanels;
import org.zeith.solarflux.util.BlockPosFace;

public class SolarPanelTile
extends TileSyncableTickable
implements IEnergyStorage,
IContainerTile {
    public long energy;
    public long currentGeneration;
    public float sunIntensity;
    private SolarPanel delegate;
    private SolarPanelInstance instance;
    public final SimpleInventory upgradeInventory = new SimpleInventory(5);
    public final SimpleInventory chargeInventory = new SimpleInventory(1);
    public final List<BlockPosFace> traversal = new ArrayList<BlockPosFace>();
    public final SimpleAttributeProperty generation = new SimpleAttributeProperty();
    public final SimpleAttributeProperty transfer = new SimpleAttributeProperty();
    public final SimpleAttributeProperty capacity = new SimpleAttributeProperty();
    List<ResourceLocation> tickedUpgrades = new ArrayList<ResourceLocation>();
    private static final Direction[] DIRECTIONS = Direction.values();
    int effCacheTime;
    float effCache;
    public boolean cache$seeSky;
    public byte cache$seeSkyTimer;
    public static final ModelProperty<Level> WORLD_PROP = new ModelProperty();
    public static final ModelProperty<BlockPos> POS_PROP = new ModelProperty();
    LazyOptional chargeableItems;
    LazyOptional energyStorageTile;
    int voxelTimer = 0;
    VoxelShape shape;

    public SolarPanelTile(BlockPos pos, BlockState state) {
        super(SolarPanels.SOLAR_PANEL_TYPE, pos, state);
    }

    public int getUpgrades(Item type) {
        int c = 0;
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            ItemStack stack = this.upgradeInventory.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != type) continue;
            c += stack.m_41613_();
        }
        return c;
    }

    public boolean isSameLevel(SolarPanelTile other) {
        if (other == null) {
            return false;
        }
        if (other.getDelegate() == null || this.getDelegate() == null) {
            return false;
        }
        return Objects.equals(other.getDelegate(), this.getDelegate());
    }

    public SolarPanel getDelegate() {
        if (this.delegate == null) {
            Block blk = this.m_58900_().m_60734_();
            this.delegate = blk instanceof SolarPanelBlock ? ((SolarPanelBlock)blk).panel : SolarPanels.CORE_PANELS[0];
        }
        return this.delegate;
    }

    public SolarPanelInstance getInstance() {
        if (this.instance == null || this.instance.getDelegate() != this.getDelegate()) {
            this.instance = this.getDelegate().createInstance(this);
        }
        return this.instance;
    }

    public void tickUpgrades() {
        ItemStack stack;
        int i;
        this.generation.clearAttributes();
        this.transfer.clearAttributes();
        this.capacity.clearAttributes();
        for (i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            stack = this.upgradeInventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof UpgradeItem && ((UpgradeItem)stack.m_41720_()).canStayInPanel(this, stack, this.upgradeInventory)) {
                ResourceLocation id = stack.m_41720_().getRegistryName();
                if (this.tickedUpgrades.contains(id)) continue;
                UpgradeItem iu = (UpgradeItem)stack.m_41720_();
                iu.update(this, stack, this.getUpgrades(iu));
                this.tickedUpgrades.add(id);
                continue;
            }
            ItemStack s = this.upgradeInventory.getStackInSlot(i);
            s.m_41777_();
            this.upgradeInventory.setStackInSlot(i, ItemStack.f_41583_);
            if (this.f_58857_.f_46443_) continue;
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack));
        }
        if (this.energy > 0L && this.getInstance() != null) {
            for (i = 0; i < this.chargeInventory.getSlots(); ++i) {
                stack = this.chargeInventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                stack.getCapability(CapabilityEnergy.ENERGY, null).filter(e -> e.getEnergyStored() < e.getMaxEnergyStored()).ifPresent(e -> {
                    this.transfer.setBaseValue(this.getInstance().transfer);
                    int transfer = this.transfer.getValueI();
                    this.energy -= (long)e.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
                });
            }
        }
        this.tickedUpgrades.clear();
    }

    public void update() {
        Block blk;
        if (this.voxelTimer > 0) {
            --this.voxelTimer;
        }
        if (!((blk = this.m_58900_().m_60734_()) instanceof SolarPanelBlock)) {
            return;
        }
        this.delegate = ((SolarPanelBlock)blk).panel;
        if (this.cache$seeSkyTimer > 0) {
            this.cache$seeSkyTimer = (byte)(this.cache$seeSkyTimer - 1);
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            this.traversal.clear();
        }
        this.tickUpgrades();
        int gen = this.getGeneration();
        this.capacity.setBaseValue(this.getInstance().cap);
        this.energy += Math.min(this.capacity.getValueL() - this.energy, (long)gen);
        this.currentGeneration = gen;
        this.energy = Math.min(Math.max(this.energy, 0L), this.capacity.getValueL());
        for (Direction hor : DIRECTIONS) {
            BlockEntity tile;
            if (hor.m_122434_() == Direction.Axis.Y || !((tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(hor))) instanceof SolarPanelTile)) continue;
            this.autoBalanceEnergy((SolarPanelTile)tile);
        }
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        for (Direction hor : DIRECTIONS) {
            BlockEntity tile;
            if (hor == Direction.UP || (tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(hor))) == null) continue;
            tile.getCapability(CapabilityEnergy.ENERGY, hor.m_122424_()).ifPresent(storage -> {
                if (storage.canReceive()) {
                    this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
                }
            });
        }
        if (!this.traversal.isEmpty()) {
            for (BlockPosFace traverse : this.traversal) {
                BlockEntity tile = this.f_58857_.m_7702_(traverse.pos);
                if (this.energy < 1L) break;
                if (tile == null) continue;
                tile.getCapability(CapabilityEnergy.ENERGY, traverse.face).ifPresent(storage -> {
                    if (storage.canReceive()) {
                        this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), Math.round((float)transfer * traverse.rate)), false);
                    }
                });
            }
        }
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        if (this.effCacheTime > 0) {
            --this.effCacheTime;
        }
    }

    public int getGeneration() {
        float eff = this.effCache;
        if (this.effCacheTime <= 0) {
            eff = this.getInstance().computeSunIntensity(this);
            float raining = this.f_58857_.m_46722_(1.0f);
            raining = raining > 0.2f ? (raining - 0.2f) / 0.8f : 0.0f;
            raining = (float)Math.sin((double)raining * Math.PI / 2.0);
            raining = 1.0f - raining * (1.0f - SolarPanels.RAIN_MULTIPLIER);
            float thundering = this.f_58857_.m_46661_(1.0f);
            thundering = thundering > 0.75f ? (thundering - 0.75f) / 0.25f : 0.0f;
            thundering = (float)Math.sin((double)thundering * Math.PI / 2.0);
            thundering = 1.0f - thundering * (1.0f - SolarPanels.THUNDER_MULTIPLIER);
            this.effCache = eff *= raining * thundering;
            this.effCacheTime = 2;
        }
        if (!this.f_58857_.f_46443_) {
            this.sunIntensity = eff;
        }
        float gen = (float)this.getInstance().gen * eff;
        this.generation.setBaseValue(gen);
        return this.generation.getValueI();
    }

    public int autoBalanceEnergy(SolarPanelTile solar) {
        int delta = this.getEnergyStored() - solar.getEnergyStored();
        if (delta < 0) {
            return solar.autoBalanceEnergy(this);
        }
        if (delta > 0) {
            return this.extractEnergy(solar.receiveEnergyInternal(this.extractEnergy(solar.receiveEnergyInternal(delta / 2, true), true), false), false);
        }
        return 0;
    }

    public boolean doesSeeSky() {
        if (this.cache$seeSkyTimer < 1) {
            this.cache$seeSkyTimer = (byte)20;
            this.cache$seeSky = this.f_58857_ != null && this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_) > 0 && this.f_58857_.m_45527_(this.f_58858_.m_7494_());
        }
        return this.cache$seeSky;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(WORLD_PROP, (Object)this.f_58857_).withInitial(POS_PROP, (Object)this.f_58858_).build();
    }

    public CompoundTag writeNBT(CompoundTag nbt) {
        this.upgradeInventory.writeToNBT(nbt, "Upgrades");
        this.chargeInventory.writeToNBT(nbt, "Chargeable");
        nbt.m_128356_("Energy", this.energy);
        return nbt;
    }

    public void readNBT(CompoundTag nbt) {
        this.upgradeInventory.readFromNBT(nbt, "Upgrades");
        this.chargeInventory.readFromNBT(nbt, "Chargeable");
        this.energy = nbt.m_128454_("Energy");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chargeableItems == null) {
                this.chargeableItems = LazyOptional.of(() -> this.chargeInventory);
            }
            return this.chargeableItems.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            if (this.energyStorageTile == null) {
                this.energyStorageTile = LazyOptional.of(() -> this);
            }
            return this.energyStorageTile.cast();
        }
        return super.getCapability(cap, side);
    }

    public void resetVoxelShape() {
        this.shape = null;
    }

    public VoxelShape getShape(SolarPanelBlock block) {
        if (this.shape == null || this.voxelTimer <= 0) {
            this.shape = block.recalcShape((BlockGetter)this.f_58857_, this.f_58858_);
            this.voxelTimer = 20;
        }
        return this.shape;
    }

    public AbstractContainerMenu openContainer(Player player, int windowId) {
        return new SolarPanelContainer(windowId, player.m_150109_(), this);
    }

    @Nullable
    public Component getDisplayName() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(transfer, maxExtract));
        if (!simulate) {
            this.energy -= (long)energyExtracted;
        }
        return energyExtracted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        this.capacity.setBaseValue(this.getInstance().cap);
        long cap = this.capacity.getValueL();
        int energyReceived = Math.min((int)Math.min(cap - this.energy, Integer.MAX_VALUE), Math.min(transfer, maxReceive));
        if (!simulate) {
            this.energy += (long)energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.energy, Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.getInstance().cap, Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public ItemStack generateItem(ItemLike item) {
        ItemStack stack = new ItemStack(item);
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("Energy", this.energy - Math.round((double)this.energy * SolarPanels.LOOSE_ENERGY / 100.0));
        this.upgradeInventory.writeToNBT(tag, "Upgrades");
        this.chargeInventory.writeToNBT(tag, "Chargeable");
        stack.m_41751_(tag);
        return stack;
    }

    public void loadFromItem(ItemStack stack) {
        if (stack.m_41782_()) {
            this.energy = stack.m_41783_().m_128454_("Energy");
            this.upgradeInventory.readFromNBT(stack.m_41783_(), "Upgrades");
            this.chargeInventory.readFromNBT(stack.m_41783_(), "Chargeable");
        }
    }

    public void setDelegate(SolarPanel delegate) {
        this.delegate = delegate;
    }
}

