/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.util;

import net.minecraft.util.Mth;

public class LerpedFloat {
    protected float current;
    protected float previous;

    public LerpedFloat() {
        this.previous = 0.0f;
        this.current = 0.0f;
    }

    public LerpedFloat(float start) {
        this.current = this.previous = start;
    }

    public float get(float x) {
        return Mth.m_144920_((float)this.previous, (float)this.current, (float)x);
    }

    public float get() {
        return this.current;
    }

    public void set(float value) {
        this.sync();
        this.current = value;
    }

    public void add(float value) {
        this.sync();
        this.current += value;
    }

    public void sync() {
        this.previous = this.current;
    }

    public float getPrevious() {
        return this.previous;
    }

    public static Clamped unit() {
        return new Clamped(0.0f, 1.0f);
    }

    public static class Clamped
    extends LerpedFloat {
        private final float min;
        private final float max;

        public Clamped(float start, float min, float max) {
            super(Mth.m_14036_((float)start, (float)min, (float)max));
            this.min = min;
            this.max = max;
        }

        public Clamped(float min, float max) {
            this(0.0f, min, max);
        }

        @Override
        public void set(float value) {
            super.set(Mth.m_14036_((float)value, (float)this.min, (float)this.max));
        }

        @Override
        public void add(float value) {
            super.add(value);
            this.current = Mth.m_14036_((float)this.current, (float)this.min, (float)this.max);
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }
    }
}

