/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuarkArmorModel
extends HumanoidModel<LivingEntity> {
    protected final EquipmentSlot slot;

    public QuarkArmorModel(ModelPart part, EquipmentSlot slot) {
        super(part);
        this.slot = slot;
    }

    public static LayerDefinition createLayer(int textureWidth, int textureHeight, Consumer<PartDefinition> rootConsumer) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        root.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        rootConsumer.accept(root);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)textureWidth, (int)textureHeight);
    }

    public void m_6973_(@Nonnull LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof ArmorStand)) {
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        ArmorStand entityIn = (ArmorStand)entity;
        this.f_102808_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31680_().m_123156_();
        this.f_102808_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31680_().m_123157_();
        this.f_102808_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31680_().m_123158_();
        this.f_102808_.m_104227_(0.0f, 1.0f, 0.0f);
        this.f_102810_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31685_().m_123156_();
        this.f_102810_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31685_().m_123157_();
        this.f_102810_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31685_().m_123158_();
        this.f_102812_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31688_().m_123156_();
        this.f_102812_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31688_().m_123157_();
        this.f_102812_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31688_().m_123158_();
        this.f_102811_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31689_().m_123156_();
        this.f_102811_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31689_().m_123157_();
        this.f_102811_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31689_().m_123158_();
        this.f_102814_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31691_().m_123156_();
        this.f_102814_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31691_().m_123157_();
        this.f_102814_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31691_().m_123158_();
        this.f_102814_.m_104227_(1.9f, 11.0f, 0.0f);
        this.f_102813_.f_104203_ = (float)Math.PI / 180 * entityIn.m_31694_().m_123156_();
        this.f_102813_.f_104204_ = (float)Math.PI / 180 * entityIn.m_31694_().m_123157_();
        this.f_102813_.f_104205_ = (float)Math.PI / 180 * entityIn.m_31694_().m_123158_();
        this.f_102813_.m_104227_(-1.9f, 11.0f, 0.0f);
        this.f_102809_.m_104315_(this.f_102808_);
    }

    public void m_7695_(@Nonnull PoseStack ms, @Nonnull VertexConsumer buffer, int light, int overlay, float r, float g, float b, float a) {
        this.setPartVisibility(this.slot);
        super.m_7695_(ms, buffer, light, overlay, r, g, b, a);
    }

    private void setPartVisibility(EquipmentSlot slot) {
        this.m_8009_(false);
        switch (slot) {
            case HEAD: {
                this.f_102808_.f_104207_ = true;
                this.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                this.f_102810_.f_104207_ = true;
                this.f_102811_.f_104207_ = true;
                this.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                this.f_102810_.f_104207_ = true;
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                break;
            }
        }
    }
}

