/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperationContext;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.ScanUtils;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class GeoScannerPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String PERIPHERAL_TYPE = "geoScanner";

    protected GeoScannerPeripheral(IPeripheralOwner owner) {
        super(PERIPHERAL_TYPE, owner);
        owner.attachOperation(SphereOperation.SCAN_BLOCKS);
    }

    public GeoScannerPeripheral(PeripheralBlockEntity<?> tileEntity) {
        this(new BlockEntityPeripheralOwner(tileEntity).attachFuel());
    }

    public GeoScannerPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side).attachFuel(1));
    }

    public GeoScannerPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    private static List<Map<String, ?>> scan(Level level, BlockPos center, int radius) {
        ArrayList result = new ArrayList();
        ScanUtils.relativeTraverseBlocks(level, center, radius, (state, pos) -> {
            HashMap<String, Object> data = new HashMap<String, Object>(6);
            data.put("x", pos.m_123341_());
            data.put("y", pos.m_123342_());
            data.put("z", pos.m_123343_());
            Block block = state.m_60734_();
            ResourceLocation name = block.getRegistryName();
            data.put("name", name == null ? "unknown" : name.toString());
            data.put("tags", LuaConverter.tagsToList(() -> block.m_204297_().m_203616_()));
            result.add(data);
        });
        return result;
    }

    private static int estimateCost(int radius) {
        if (radius > SphereOperation.SCAN_BLOCKS.getMaxCostRadius()) {
            return -1;
        }
        return SphereOperation.SCAN_BLOCKS.getCost(SphereOperationContext.of(radius));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableGeoScanner.get();
    }

    @LuaFunction
    public final MethodResult cost(int radius) {
        int estimatedCost = GeoScannerPeripheral.estimateCost(radius);
        if (estimatedCost < 0) {
            return MethodResult.of((Object[])new Object[]{null, "Radius is exceed max value"});
        }
        return MethodResult.of((Object)estimatedCost);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult chunkAnalyze() throws LuaException {
        return this.withOperation(SphereOperation.SCAN_BLOCKS, SphereOperation.SCAN_BLOCKS.free(), null, ignored -> {
            Level level = this.getLevel();
            LevelChunk chunk = level.m_46745_(this.getPos());
            ChunkPos chunkPos = chunk.m_7697_();
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            for (int x = chunkPos.m_45604_(); x <= chunkPos.m_45608_(); ++x) {
                for (int z = chunkPos.m_45605_(); z <= chunkPos.m_45609_(); ++z) {
                    for (int y = level.m_6042_().m_156732_(); y < level.m_6042_().m_156733_(); ++y) {
                        BlockState block = chunk.m_8055_(new BlockPos(x, y, z));
                        ResourceLocation name = block.m_60734_().getRegistryName();
                        if (name == null || !block.m_204336_(Tags.Blocks.ORES)) continue;
                        data.put(name.toString(), data.getOrDefault(name.toString(), 0) + 1);
                    }
                }
            }
            return MethodResult.of(data);
        }, null);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult scan(@NotNull IArguments arguments) throws LuaException {
        int radius = arguments.getInt(0);
        return this.withOperation(SphereOperation.SCAN_BLOCKS, new SphereOperationContext(radius), context -> {
            if (context.getRadius() > SphereOperation.SCAN_BLOCKS.getMaxCostRadius()) {
                return MethodResult.of((Object[])new Object[]{null, "Radius is exceed max value"});
            }
            return null;
        }, context -> MethodResult.of(GeoScannerPeripheral.scan(this.getLevel(), this.getPos(), context.getRadius())), null);
    }
}

