/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.util.block_tracking;

import com.abdelaziz.canary.common.block.BlockCountingSection;
import com.abdelaziz.canary.common.block.BlockStateFlagHolder;
import com.abdelaziz.canary.common.block.BlockStateFlags;
import com.abdelaziz.canary.common.block.TrackedBlockStatePredicate;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LevelChunkSection.class})
public abstract class LevelChunkSectionMixin
implements BlockCountingSection {
    @Shadow
    @Final
    private PalettedContainer<BlockState> f_62972_;
    @Unique
    private short[] countsByFlag = null;
    private CompletableFuture<short[]> countsByFlagFuture;

    @Override
    public boolean anyMatch(TrackedBlockStatePredicate trackedBlockStatePredicate, boolean fallback) {
        if (this.countsByFlag == null && !this.tryInitializeCountsByFlag()) {
            return fallback;
        }
        return this.countsByFlag[trackedBlockStatePredicate.getIndex()] != 0;
    }

    private static short[] calculateCanaryCounts(PalettedContainer<BlockState> states) {
        short[] countsByFlag = new short[BlockStateFlags.NUM_FLAGS];
        states.m_63099_((state, count) -> LevelChunkSectionMixin.addToFlagCount(countsByFlag, state, count));
        return countsByFlag;
    }

    private boolean tryInitializeCountsByFlag() {
        CompletableFuture<short[]> countsByFlagFuture = this.countsByFlagFuture;
        if (countsByFlagFuture != null && countsByFlagFuture.isDone()) {
            try {
                this.countsByFlag = (short[])countsByFlagFuture.get();
                return true;
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                this.countsByFlagFuture = null;
            }
        }
        if (this.countsByFlagFuture == null) {
            PalettedContainer<BlockState> states = this.f_62972_;
            this.countsByFlagFuture = CompletableFuture.supplyAsync(() -> LevelChunkSectionMixin.calculateCanaryCounts(states), Util.m_183991_());
        }
        return false;
    }

    @Redirect(method={"recalcBlockCounts()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer;count(Lnet/minecraft/world/level/chunk/PalettedContainer$CountConsumer;)V"))
    private void initFlagCounters(PalettedContainer<BlockState> palettedContainer, PalettedContainer.CountConsumer<BlockState> consumer) {
        palettedContainer.m_63099_((state, count) -> {
            consumer.m_63144_(state, count);
            LevelChunkSectionMixin.addToFlagCount(this.countsByFlag, state, count);
        });
    }

    private static void addToFlagCount(short[] countsByFlag, BlockState state, int change) {
        int i;
        int flags = ((BlockStateFlagHolder)state).getAllFlags();
        while ((i = Integer.numberOfTrailingZeros(flags)) < 32) {
            int n = i;
            countsByFlag[n] = (short)(countsByFlag[n] + change);
            flags &= ~(1 << i);
        }
    }

    @Inject(method={"recalcBlockCounts()V"}, at={@At(value="HEAD")})
    private void createFlagCounters(CallbackInfo ci) {
        this.countsByFlag = new short[BlockStateFlags.NUM_FLAGS];
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")})
    private void joinFuture(int x, int y, int z, BlockState state, boolean lock, CallbackInfoReturnable<BlockState> cir) {
        if (this.countsByFlagFuture != null) {
            this.countsByFlag = this.countsByFlagFuture.join();
            this.countsByFlagFuture = null;
        }
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private void resetData(FriendlyByteBuf buf, CallbackInfo ci) {
        this.countsByFlag = null;
        this.countsByFlagFuture = null;
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFluidState()Lnet/minecraft/world/level/material/FluidState;", ordinal=0, shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void updateFlagCounters(int x, int y, int z, BlockState newState, boolean lock, CallbackInfoReturnable<BlockState> cir, BlockState oldState) {
        int i;
        short[] countsByFlag = this.countsByFlag;
        if (countsByFlag == null) {
            return;
        }
        int prevFlags = ((BlockStateFlagHolder)oldState).getAllFlags();
        int flags = ((BlockStateFlagHolder)newState).getAllFlags();
        int flagsXOR = prevFlags ^ flags;
        while ((i = Integer.numberOfTrailingZeros(flagsXOR)) < 32) {
            int n = i;
            countsByFlag[n] = (short)(countsByFlag[n] + (1 - ((prevFlags >>> i & 1) << 1)));
            flagsXOR &= ~(1 << i);
        }
    }
}

