/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.multiloader.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MountedToolboxSyncPacket
implements S2CPacket {
    final int id;
    final CompoundTag nbt;

    public MountedToolboxSyncPacket(Entity target, CompoundTag nbt) {
        this.id = target.m_142049_();
        this.nbt = nbt;
    }

    public MountedToolboxSyncPacket(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.nbt = buf.m_130260_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.m_130079_(this.nbt);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        Entity target;
        ClientLevel level = mc.f_91073_;
        if (level != null && (target = level.m_6815_(this.id)) instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)target;
            conductor.getOrCreateToolboxHolder().read(this.nbt, true);
        }
    }
}

