/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.mixin_interfaces.IMonorailBezier;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BezierConnection.class}, remap=false)
public abstract class MixinBezierConnectionClient
implements IMonorailBezier {
    private IMonorailBezier.MonorailAngles[] bakedMonorails;

    @Shadow
    public abstract int getSegmentCount();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IMonorailBezier.MonorailAngles[] getBakedMonorails() {
        if (this.bakedMonorails != null) {
            return this.bakedMonorails;
        }
        int segmentCount = this.getSegmentCount();
        this.bakedMonorails = new IMonorailBezier.MonorailAngles[segmentCount + 1];
        Couple previousOffsets = null;
        BezierConnection this_ = (BezierConnection)this;
        for (BezierConnection.Segment segment : this_) {
            int i = segment.index;
            boolean end = i == 0 || i == segmentCount;
            IMonorailBezier.MonorailAngles angles = this.bakedMonorails[i] = new IMonorailBezier.MonorailAngles();
            Vec3 mainGirder = segment.position;
            Vec3 upNormal = segment.derivative.m_82541_().m_82537_(segment.normal);
            Vec3 firstGirderOffset = upNormal.m_82490_(0.5);
            Vec3 secondGirderOffset = upNormal.m_82490_(-0.625);
            Vec3 mainTop = segment.position.m_82549_(firstGirderOffset);
            Vec3 mainBottom = mainTop.m_82549_(secondGirderOffset);
            angles.lightPosition = new BlockPos(mainGirder);
            Couple offsets = Couple.create((Object)mainTop, (Object)mainBottom);
            if (previousOffsets == null) {
                previousOffsets = offsets;
                continue;
            }
            angles.beam = null;
            angles.beamCaps = Couple.create(null, null);
            float scale = end ? 2.3f : 2.2f;
            Vec3 currentBeam = ((Vec3)offsets.getFirst()).m_82549_((Vec3)offsets.getSecond()).m_82490_(0.5);
            Vec3 previousBeam = ((Vec3)previousOffsets.getFirst()).m_82549_((Vec3)previousOffsets.getSecond()).m_82490_(0.5);
            Vec3 beamDiff = currentBeam.m_82546_(previousBeam);
            Vec3 beamAngles = TrackRenderer.getModelAngles((Vec3)segment.normal, (Vec3)beamDiff);
            PoseStack poseStack = new PoseStack();
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).translate(previousBeam)).rotateYRadians(beamAngles.f_82480_)).rotateXRadians(beamAngles.f_82479_)).rotateZRadians(beamAngles.f_82481_)).translate(0.0, (double)(0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f), -0.03125)).scale(1.0f, 1.0f, (float)beamDiff.m_82553_() * scale);
            angles.beam = poseStack.m_85850_();
            for (boolean top : Iterate.trueAndFalse) {
                Vec3 current = (Vec3)offsets.get(top);
                Vec3 previous = (Vec3)previousOffsets.get(top);
                Vec3 diff = current.m_82546_(previous);
                Vec3 capAngles = TrackRenderer.getModelAngles((Vec3)segment.normal, (Vec3)diff);
                poseStack = new PoseStack();
                ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).translate(previous)).rotateYRadians(capAngles.f_82480_)).rotateXRadians(capAngles.f_82479_)).rotateZRadians(capAngles.f_82481_)).translate(0.0, (double)(0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f), -0.03125)).rotateZ(0.0)).scale(1.0f, 1.0f, (float)diff.m_82553_() * scale);
                angles.beamCaps.set(top, (Object)poseStack.m_85850_());
            }
            previousOffsets = offsets;
        }
        return this.bakedMonorails;
    }
}

