/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxContainer;
import com.railwayteam.railways.content.conductor.toolbox.forge.MountedToolboxImpl;
import com.railwayteam.railways.mixin.AccessorBlockEntity;
import com.railwayteam.railways.mixin.AccessorToolboxBlockEntity;
import com.railwayteam.railways.util.packet.PacketSender;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MountedToolbox
extends ToolboxBlockEntity {
    protected final ConductorEntity parent;

    public MountedToolbox(ConductorEntity parent, DyeColor dyeColor) {
        super((BlockEntityType)AllBlockEntityTypes.TOOLBOX.get(), parent.m_142538_(), AllBlocks.TOOLBOXES.get(dyeColor).getDefaultState());
        this.parent = parent;
        this.m_142339_(parent.f_19853_);
        this.setLazyTickRate(10);
    }

    public void readFromItem(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        this.readInventory(tag.m_128469_("Inventory"));
        if (tag.m_128441_("UniqueId")) {
            this.setUniqueId(tag.m_128342_("UniqueId"));
        }
        if (stack.m_41788_()) {
            this.setCustomName(stack.m_41786_());
        }
    }

    public ConductorEntity getParent() {
        return this.parent;
    }

    public void tick() {
        ((AccessorBlockEntity)((Object)this)).setWorldPosition(this.parent.m_142538_());
        super.tick();
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128425_("Color", 3)) {
            DyeColor color = DyeColor.m_41053_((int)compound.m_128451_("Color"));
            BlockState state = ((ToolboxBlock)AllBlocks.TOOLBOXES.get(color).get()).m_49966_();
            this.m_155250_(state);
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Color", this.getColor().m_41060_());
    }

    public List<Player> getConnectedPlayers() {
        Map<Integer, WeakHashMap<Player, Integer>> connectedPlayers = ((AccessorToolboxBlockEntity)((Object)this)).getConnectedPlayers();
        HashSet<Player> players = new HashSet<Player>();
        for (Map.Entry<Integer, WeakHashMap<Player, Integer>> entry : connectedPlayers.entrySet()) {
            players.addAll(entry.getValue().keySet());
        }
        return players.stream().toList();
    }

    public void sendData() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        this.write(nbt, true);
        PacketSender.syncMountedToolboxNBT((Entity)this.parent, nbt);
    }

    public void m_6596_() {
    }

    public static MountedToolbox read(ConductorEntity parent, CompoundTag compound) {
        MountedToolbox holder = new MountedToolbox(parent, DyeColor.BROWN);
        holder.read(compound, false);
        return holder;
    }

    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return MountedToolboxContainer.create(id, inv, this);
    }

    public ItemStack getDisplayStack() {
        ItemStack stack = new ItemStack((ItemLike)AllBlocks.TOOLBOXES.get(this.getColor()).get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public ItemStack getCloneItemStack() {
        ItemStack stack = this.getDisplayStack();
        CompoundTag tag = stack.m_41784_();
        CompoundTag data = new CompoundTag();
        this.write(data, false);
        CompoundTag inv = data.m_128469_("Inventory");
        tag.m_128365_("Inventory", (Tag)inv);
        tag.m_128362_("UniqueId", this.getUniqueId());
        return stack;
    }

    public void sendToMenu(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.parent.m_142049_());
        buffer.m_130079_(this.m_5995_());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openMenu(ServerPlayer player, MountedToolbox toolbox) {
        void var1_1;
        MountedToolboxImpl.openMenu(player, (MountedToolbox)var1_1);
    }
}

