/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.api.IStorageCallback;
import cofh.lib.api.StorageGroup;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SimpleItemInv
extends SimpleItemHandler {
    protected String tag;
    protected IItemHandler allHandler;

    public SimpleItemInv(@Nonnull List<ItemStorageCoFH> slots) {
        this(null, slots, "ItemInv");
    }

    public SimpleItemInv(@Nullable IStorageCallback callback) {
        this(callback, "ItemInv");
    }

    public SimpleItemInv(@Nullable IStorageCallback callback, @Nonnull List<ItemStorageCoFH> slots) {
        this(callback, slots, "ItemInv");
    }

    public SimpleItemInv(@Nullable IStorageCallback callback, @Nonnull String tag) {
        this(callback, Collections.emptyList(), tag);
    }

    public SimpleItemInv(@Nullable IStorageCallback callback, @Nonnull List<ItemStorageCoFH> slots, @Nonnull String tag) {
        super(callback, slots);
        this.tag = tag;
    }

    public void addSlot(ItemStorageCoFH slot) {
        if (this.allHandler != null) {
            return;
        }
        this.slots.add(slot);
    }

    public void clear() {
        for (ItemStorageCoFH slot : this.slots) {
            slot.setItemStack(ItemStack.f_41583_);
        }
    }

    public void set(int slot, ItemStack stack) {
        ((ItemStorageCoFH)this.slots.get(slot)).setItemStack(stack);
    }

    public ItemStack get(int slot) {
        return ((ItemStorageCoFH)this.slots.get(slot)).getItemStack();
    }

    public ItemStorageCoFH getSlot(int slot) {
        return (ItemStorageCoFH)this.slots.get(slot);
    }

    public SimpleItemInv read(CompoundTag nbt) {
        for (ItemStorageCoFH slot : this.slots) {
            slot.setItemStack(ItemStack.f_41583_);
        }
        ListTag list = nbt.m_128437_(this.tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag slotTag = list.m_128728_(i);
            byte slot = slotTag.m_128445_("Slot");
            if (slot < 0 || slot >= this.slots.size()) continue;
            ((ItemStorageCoFH)this.slots.get(slot)).read(slotTag);
        }
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.slots.size() <= 0) {
            return nbt;
        }
        ListTag list = new ListTag();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (((ItemStorageCoFH)this.slots.get(i)).isEmpty()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128344_("Slot", (byte)i);
            ((ItemStorageCoFH)this.slots.get(i)).write(slotTag);
            list.add((Object)slotTag);
        }
        if (!list.isEmpty()) {
            nbt.m_128365_(this.tag, (Tag)list);
        } else {
            nbt.m_128473_(this.tag);
        }
        return nbt;
    }

    public CompoundTag writeSlotsToNBT(CompoundTag nbt, int startIndex, int endIndex) {
        return this.writeSlotsToNBT(nbt, this.tag, startIndex, endIndex);
    }

    public CompoundTag writeSlotsToNBT(CompoundTag nbt, String saveTag, int startIndex) {
        return this.writeSlotsToNBT(nbt, saveTag, startIndex, this.slots.size());
    }

    public CompoundTag writeSlotsToNBT(CompoundTag nbt, String saveTag, int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= endIndex || startIndex >= this.slots.size()) {
            return nbt;
        }
        ListTag list = new ListTag();
        for (int i = startIndex; i < Math.min(endIndex, this.slots.size()); ++i) {
            if (((ItemStorageCoFH)this.slots.get(i)).isEmpty()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128344_("Slot", (byte)i);
            ((ItemStorageCoFH)this.slots.get(i)).write(slotTag);
            list.add((Object)slotTag);
        }
        if (!list.isEmpty()) {
            nbt.m_128365_(saveTag, (Tag)list);
        } else {
            nbt.m_128473_(this.tag);
        }
        return nbt;
    }

    public SimpleItemInv readSlotsUnordered(ListTag list, int startIndex) {
        return this.readSlotsUnordered(list, startIndex, this.slots.size());
    }

    public SimpleItemInv readSlotsUnordered(ListTag list, int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= endIndex || startIndex >= this.slots.size()) {
            return this;
        }
        for (int i = 0; i < Math.min(Math.min(endIndex, this.slots.size()) - startIndex, list.size()); ++i) {
            CompoundTag slotTag = list.m_128728_(i);
            ((ItemStorageCoFH)this.slots.get(startIndex + i)).read(slotTag);
        }
        return this;
    }

    public CompoundTag writeSlotsToNBTUnordered(CompoundTag nbt, int startIndex, int endIndex) {
        return this.writeSlotsToNBTUnordered(nbt, this.tag, startIndex, endIndex);
    }

    public CompoundTag writeSlotsToNBTUnordered(CompoundTag nbt, String saveTag, int startIndex) {
        return this.writeSlotsToNBTUnordered(nbt, saveTag, startIndex, this.slots.size());
    }

    public CompoundTag writeSlotsToNBTUnordered(CompoundTag nbt, String saveTag, int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= endIndex || startIndex >= this.slots.size()) {
            return nbt;
        }
        ListTag list = new ListTag();
        for (int i = startIndex; i < Math.min(endIndex, this.slots.size()); ++i) {
            if (((ItemStorageCoFH)this.slots.get(i)).isEmpty()) continue;
            CompoundTag slotTag = new CompoundTag();
            ((ItemStorageCoFH)this.slots.get(i)).write(slotTag);
            list.add((Object)slotTag);
        }
        if (!list.isEmpty()) {
            nbt.m_128365_(saveTag, (Tag)list);
        } else {
            nbt.m_128473_(saveTag);
        }
        return nbt;
    }

    public IItemHandler getHandler(StorageGroup group) {
        if (this.allHandler == null) {
            ((ArrayList)this.slots).trimToSize();
            this.allHandler = new SimpleItemHandler(this.callback, this.slots);
        }
        return this.allHandler;
    }
}

