/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileStatePacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;
    protected FriendlyByteBuf buffer;

    public TileStatePacket() {
        super(4, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        Level world = ProxyUtils.getClientWorld();
        if (world == null) {
            CoFHCore.LOG.error("Client world is null! (Is this being called on the server?)");
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IPacketHandlerTile) {
            IPacketHandlerTile handlerTile = (IPacketHandlerTile)tile;
            handlerTile.handleStatePacket(this.buffer);
            BlockState state = tile.m_58904_().m_8055_(this.pos);
            tile.m_58904_().m_7260_(this.pos, state, state, 3);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.buffer = buf;
        this.pos = this.buffer.m_130135_();
    }

    public static void sendToClient(IPacketHandlerTile tile) {
        if (tile.world() == null || Utils.isClientWorld(tile.world())) {
            return;
        }
        TileStatePacket packet = new TileStatePacket();
        packet.pos = tile.pos();
        packet.buffer = tile.getStatePacket(new FriendlyByteBuf(Unpooled.buffer()));
        packet.sendToAllAround(packet.pos, 192.0, (ResourceKey<Level>)tile.world().m_46472_());
    }
}

