/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.entity.AbstractMinecartCoFH;
import cofh.core.item.ItemCoFH;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class MinecartItemCoFH
extends ItemCoFH {
    protected final IMinecartFactory<? extends AbstractMinecartCoFH> factory;
    private static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel world = source.m_7727_();
            double d0 = source.m_7096_() + (double)direction.m_122429_() * 1.125;
            double d1 = Math.floor(source.m_7098_()) + (double)direction.m_122430_();
            double d2 = source.m_7094_() + (double)direction.m_122431_() * 1.125;
            BlockPos blockpos = source.m_7961_().m_142300_(direction);
            BlockState blockstate = world.m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock rail = (BaseRailBlock)block;
                v0 = rail.getRailDirection(blockstate, (BlockGetter)world, blockpos, null);
            } else {
                v0 = railshape = RailShape.NORTH_SOUTH;
            }
            if (blockstate.m_204336_(BlockTags.f_13034_)) {
                d3 = railshape.m_61745_() ? 0.6 : 0.1;
            } else {
                RailShape railShape;
                if (!blockstate.m_60795_() || !world.m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    return this.behaviourDefaultDispenseItem.m_6115_(source, stack);
                }
                BlockState state = world.m_8055_(blockpos.m_7495_());
                Block block2 = state.m_60734_();
                if (block2 instanceof BaseRailBlock) {
                    BaseRailBlock rail = (BaseRailBlock)block2;
                    railShape = rail.getRailDirection(state, (BlockGetter)world, blockpos.m_7495_(), null);
                } else {
                    railShape = RailShape.NORTH_SOUTH;
                }
                RailShape shape = railShape;
                d3 = direction != Direction.DOWN && shape.m_61745_() ? -0.4 : -0.9;
            }
            if (stack.m_41720_() instanceof MinecartItemCoFH) {
                ((MinecartItemCoFH)stack.m_41720_()).createMinecart(stack, (Level)world, d0, d1 + d3, d2);
                stack.m_41774_(1);
            }
            return stack;
        }
    };

    public MinecartItemCoFH(IMinecartFactory<? extends AbstractMinecartCoFH> factory, Item.Properties builder) {
        super(builder);
        this.factory = factory;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        BlockState blockstate = world.m_8055_(blockpos = context.m_8083_());
        if (!blockstate.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        if (!world.f_46443_) {
            RailShape railShape;
            Block block = blockstate.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock rail = (BaseRailBlock)block;
                railShape = rail.getRailDirection(blockstate, (BlockGetter)world, blockpos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double d0 = 0.0;
            if (railshape.m_61745_()) {
                d0 = 0.5;
            }
            this.createMinecart(stack, world, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5);
        }
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    protected void createMinecart(ItemStack stack, Level world, double posX, double posY, double posZ) {
        AbstractMinecartCoFH minecart = this.factory.createMinecart(world, posX, posY, posZ);
        if (stack.m_41788_()) {
            minecart.m_6593_(stack.m_41786_());
        }
        minecart.onPlaced(stack);
        world.m_7967_((Entity)minecart);
    }

    public static interface IMinecartFactory<T extends AbstractMinecart> {
        public T createMinecart(Level var1, double var2, double var4, double var6);
    }
}

