/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.config.CoreClientConfig;
import cofh.lib.api.item.ICoFHItem;
import cofh.lib.util.Constants;
import cofh.lib.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BlockItemCoFH
extends BlockItem
implements ICoFHItem {
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected int burnTime = -1;
    protected int enchantability;
    protected String modId = "";
    protected Supplier<CreativeModeTab> displayGroup;

    public BlockItemCoFH(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public BlockItemCoFH setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public BlockItemCoFH setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    @Override
    public BlockItemCoFH setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    @Override
    public BlockItemCoFH setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    @Override
    public BlockItemCoFH setModId(String modId) {
        this.modId = modId;
        return this;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.m_40614_() == null || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ArrayList<Component> additionalTooltips = new ArrayList<Component>();
        this.tooltipDelegate(stack, worldIn, additionalTooltips, flagIn);
        if (!additionalTooltips.isEmpty()) {
            if (Screen.m_96638_() || CoreClientConfig.alwaysShowDetails.get().booleanValue()) {
                tooltip.addAll(additionalTooltips);
            } else if (CoreClientConfig.holdShiftForDetails.get().booleanValue()) {
                tooltip.add((Component)StringHelper.getTextComponent("info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.enchantability > 0;
    }

    public int m_6473_() {
        return this.enchantability;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return this.burnTime;
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }
}

