/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg.entries;

import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigInteger;
import org.zeith.hammerlib.util.cfg.ConfigEntrySerializer;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.ReaderHelper;
import org.zeith.hammerlib.util.cfg.entries.ConfigEntryBigInt;

public class ConfigSerializerBigInt
extends ConfigEntrySerializer<ConfigEntryBigInt> {
    public ConfigSerializerBigInt() {
        super("BI");
    }

    @Override
    public void write(ConfigFile config, BufferedWriter writer, ConfigEntryBigInt entry, int indents) throws IOException {
        if (entry.getDescription() != null) {
            Object range = entry.min != null ? "[" + entry.min + ";" : "(-Inf;";
            range = entry.max != null ? (String)range + entry.max + "]" : (String)range + "+Inf)";
            this.writeComment(writer, entry.getDescription() + " (Default: " + entry.initialValue + ", Range: " + (String)range + ")", indents);
        }
        this.writeIndents(writer, indents);
        writer.write("+" + this.type + ":" + entry.getSerializedName() + "=" + entry.getValue() + "\n\n");
    }

    @Override
    public ConfigEntryBigInt read(ConfigFile config, ReaderHelper reader, int indents) throws IOException {
        ConfigEntryBigInt lnt = new ConfigEntryBigInt(config, null);
        reader.until('+', true);
        if (reader.eat(this.type, true) && reader.eat(':', true)) {
            String name = reader.until('=', true);
            String value = reader.getRest();
            if (value.contains("\n")) {
                value = value.substring(0, value.indexOf(10));
            }
            lnt.name = name;
            try {
                lnt.value = new BigInteger(value);
                if (lnt.min != null) {
                    lnt.value = lnt.value.max(lnt.min);
                }
                if (lnt.max != null) {
                    lnt.value = lnt.value.min(lnt.max);
                }
            }
            catch (NumberFormatException nfe) {
                lnt.value = null;
            }
        }
        return lnt;
    }
}

