/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.List;
import java.util.Random;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AABBUtils {
    public static boolean almostEqual(double a, double b) {
        return a - b > -1.0E-4 && a - b < 1.0E-4;
    }

    public static Vec3 randomPosWithin(AABB aabb, Random rng) {
        double x = aabb.f_82288_ + (aabb.f_82291_ - aabb.f_82288_) * rng.nextDouble();
        double y = aabb.f_82289_ + (aabb.f_82292_ - aabb.f_82289_) * rng.nextDouble();
        double z = aabb.f_82290_ + (aabb.f_82293_ - aabb.f_82290_) * rng.nextDouble();
        return new Vec3(x, y, z);
    }

    public static AABB rotate(AABB aabb, Rotation rotationIn) {
        switch (rotationIn) {
            default: {
                return aabb;
            }
            case CLOCKWISE_90: {
                return new AABB(-aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, -aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            }
            case CLOCKWISE_180: {
                return new AABB(-aabb.f_82288_, aabb.f_82289_, -aabb.f_82290_, -aabb.f_82291_, aabb.f_82292_, -aabb.f_82293_);
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new AABB(aabb.f_82288_, aabb.f_82289_, -aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, -aabb.f_82293_);
    }

    public static AABB normalize(AABB aabb) {
        return aabb.m_82386_(-aabb.f_82288_, -aabb.f_82289_, -aabb.f_82290_);
    }

    public static AABB partial(AABB prev, AABB cur, float partialTicks) {
        double x1 = prev.f_82288_ + (cur.f_82288_ - prev.f_82288_) * (double)partialTicks;
        double y1 = prev.f_82289_ + (cur.f_82289_ - prev.f_82289_) * (double)partialTicks;
        double z1 = prev.f_82290_ + (cur.f_82290_ - prev.f_82290_) * (double)partialTicks;
        double x2 = prev.f_82291_ + (cur.f_82291_ - prev.f_82291_) * (double)partialTicks;
        double y2 = prev.f_82292_ + (cur.f_82292_ - prev.f_82292_) * (double)partialTicks;
        double z2 = prev.f_82293_ + (cur.f_82293_ - prev.f_82293_) * (double)partialTicks;
        return new AABB(x1, y1, z1, x2, y2, z2);
    }

    public static AABB extrudeGravity(AABB aabb, float ySpeed) {
        float ay = Math.abs(ySpeed);
        return aabb.m_82377_((double)(-ay) * (aabb.f_82291_ - aabb.f_82288_) / 2.0, (double)ay * (aabb.f_82292_ - aabb.f_82289_) / 2.0, (double)(-ay) * (aabb.f_82293_ - aabb.f_82290_) / 2.0).m_82386_(0.0, (double)(-ySpeed) * (aabb.f_82292_ - aabb.f_82289_) / 2.0, 0.0);
    }

    public static void cut(AABB box, AABB knife, List<AABB> intoList) {
        boolean ea2;
        boolean ea1;
        if (!box.m_82381_(knife)) {
            intoList.add(box);
            return;
        }
        AABB inter = box.m_82323_(knife);
        if (!AABBUtils.almostEqual(box.f_82289_, inter.f_82289_)) {
            intoList.add(new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, inter.f_82289_, box.f_82293_));
        }
        if (!AABBUtils.almostEqual(box.f_82292_, inter.f_82292_)) {
            intoList.add(new AABB(box.f_82288_, inter.f_82292_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_));
        }
        if (ea1 = !AABBUtils.almostEqual(box.f_82291_, inter.f_82291_)) {
            intoList.add(new AABB(inter.f_82291_, inter.f_82289_, box.f_82290_, box.f_82291_, inter.f_82292_, inter.f_82293_));
        }
        if (ea2 = !AABBUtils.almostEqual(box.f_82293_, inter.f_82293_)) {
            intoList.add(new AABB(box.f_82288_, inter.f_82289_, inter.f_82293_, inter.f_82291_, inter.f_82292_, box.f_82293_));
        }
        if (ea1 && ea2) {
            intoList.add(new AABB(inter.f_82291_, inter.f_82289_, inter.f_82293_, box.f_82291_, inter.f_82292_, box.f_82293_));
        }
        if (ea1 = !AABBUtils.almostEqual(box.f_82290_, inter.f_82290_)) {
            intoList.add(new AABB(inter.f_82288_, inter.f_82289_, box.f_82290_, inter.f_82291_, inter.f_82292_, inter.f_82290_));
        }
        if (ea2 = !AABBUtils.almostEqual(box.f_82288_, inter.f_82288_)) {
            intoList.add(new AABB(box.f_82288_, inter.f_82289_, inter.f_82290_, inter.f_82288_, inter.f_82292_, inter.f_82293_));
        }
        if (ea1 || ea2) {
            intoList.add(new AABB(box.f_82288_, inter.f_82289_, box.f_82290_, inter.f_82288_, inter.f_82292_, inter.f_82290_));
        }
    }

    public static Vec3 getCenter(AABB aabb) {
        return new Vec3(aabb.f_82288_ + (aabb.f_82291_ - aabb.f_82288_) * 0.5, aabb.f_82289_ + (aabb.f_82292_ - aabb.f_82289_) * 0.5, aabb.f_82290_ + (aabb.f_82293_ - aabb.f_82290_) * 0.5);
    }
}

