/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.config.Config;
import org.zeith.hammerlib.api.config.ConfigException;
import org.zeith.hammerlib.api.config.ConfigHolder;
import org.zeith.hammerlib.api.config.IConfigStructure;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.entries.ConfigEntryCategory;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public interface IConfigRoot {
    default public boolean avoidSync() {
        return false;
    }

    default public void toNetwork(CompoundTag tag) {
        for (Field field : ReflectionUtil.getFieldsUpTo(this.getClass(), Object.class)) {
            if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Config.AvoidSync.class) || field.isAnnotationPresent(Config.LoadOnlyIn.class)) continue;
            try {
                String tmp0;
                Config.ConfigEntry ea = field.getAnnotation(Config.ConfigEntry.class);
                String name = ea != null && (tmp0 = ea.entry()) != null && !tmp0.isEmpty() ? ea.entry() : field.getName();
                Class<?> type = field.getType();
                if (IConfigStructure.class.isAssignableFrom(type)) {
                    IConfigStructure struct = (IConfigStructure)field.get(this);
                    if (struct == null) continue;
                    CompoundTag sub = new CompoundTag();
                    struct.toNetwork(sub);
                    tag.m_128365_(name, (Tag)sub);
                    continue;
                }
                throw new ConfigException("Unknown field type for config root in field: " + field);
            }
            catch (Throwable err) {
                if (err instanceof ConfigException) {
                    ConfigException ce = (ConfigException)err;
                    throw ce;
                }
                if (err instanceof ReflectiveOperationException) {
                    HammerLib.LOG.error("Reflective operation occurred while writing configs to network from " + this.getClass().getName(), err);
                }
                throw new ConfigException(err);
            }
        }
    }

    default public void fromNetwork(CompoundTag tag) {
        for (Field field : ReflectionUtil.getFieldsUpTo(this.getClass(), Object.class)) {
            if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Config.AvoidSync.class) || field.isAnnotationPresent(Config.LoadOnlyIn.class)) continue;
            try {
                String tmp0;
                Config.ConfigEntry ea = field.getAnnotation(Config.ConfigEntry.class);
                String name = ea != null && (tmp0 = ea.entry()) != null && !tmp0.isEmpty() ? ea.entry() : field.getName();
                Class<?> type = field.getType();
                if (IConfigStructure.class.isAssignableFrom(type)) {
                    IConfigStructure struct = (IConfigStructure)field.get(this);
                    if (struct == null) {
                        struct = (IConfigStructure)UnsafeHacks.newInstance(type.asSubclass(IConfigStructure.class));
                        field.set(this, struct);
                    }
                    if (!tag.m_128425_(name, 10)) continue;
                    struct.fromNetwork(tag.m_128469_(name));
                    continue;
                }
                throw new ConfigException("Unknown field type for config root in field: " + field);
            }
            catch (Throwable err) {
                if (err instanceof ConfigException) {
                    ConfigException ce = (ConfigException)err;
                    throw ce;
                }
                if (err instanceof ReflectiveOperationException) {
                    HammerLib.LOG.error("Reflective operation occurred while reading configs from network into " + this.getClass().getName(), err);
                }
                throw new ConfigException(err);
            }
        }
    }

    default public void load(ConfigFile file) throws ConfigException {
        for (Field field : ReflectionUtil.getFieldsUpTo(this.getClass(), Object.class)) {
            if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Config.LoadOnlyIn.class) && FMLEnvironment.dist != field.getAnnotation(Config.LoadOnlyIn.class).value()) continue;
            try {
                String tmp0;
                Config.ConfigEntry ea = field.getAnnotation(Config.ConfigEntry.class);
                String name = ea != null && (tmp0 = ea.entry()) != null && !tmp0.isEmpty() ? ea.entry() : field.getName();
                String description = ea != null ? ea.comment() : null;
                Class<?> type = field.getType();
                if (IConfigStructure.class.isAssignableFrom(type)) {
                    ConfigEntryCategory sub = file.getCategory(name).setDescription(description);
                    IConfigStructure struct = (IConfigStructure)field.get(this);
                    if (struct == null) {
                        struct = (IConfigStructure)UnsafeHacks.newInstance(type.asSubclass(IConfigStructure.class));
                        field.set(this, struct);
                    }
                    struct.load(sub);
                    continue;
                }
                throw new ConfigException("Unknown field type for config root in field: " + field);
            }
            catch (Throwable err) {
                if (err instanceof ConfigException) {
                    ConfigException ce = (ConfigException)err;
                    throw ce;
                }
                if (err instanceof ReflectiveOperationException) {
                    HammerLib.LOG.error("Reflective operation occurred while applying configs into " + this.getClass().getName(), err);
                }
                throw new ConfigException(err);
            }
        }
    }

    default public void updateInstance(LogicalSide side) throws ConfigException {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !ConfigHolder.class.isAssignableFrom(field.getType())) continue;
            try {
                if (!ReflectionUtil.doesParameterTypeArgsMatch(field, this.getClass())) {
                    throw new ConfigException("Found non-self config holder " + field);
                }
                ((ConfigHolder)field.get(null)).update(this, side);
            }
            catch (Throwable err) {
                if (err instanceof ConfigException) {
                    ConfigException ce = (ConfigException)err;
                    throw ce;
                }
                if (err instanceof ReflectiveOperationException) {
                    HammerLib.LOG.error("Reflective operation occurred while applying configs into " + this.getClass().getName(), err);
                }
                throw new ConfigException(err);
            }
        }
    }
}

