/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.capabilities.oxygen.CapabilityOxygen;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.entities.LanderEntity;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;

@Mod.EventBusSubscriber(modid="beyond_earth", value={Dist.CLIENT})
public class Overlays {
    private static boolean check = false;
    private static float counter = 0.0f;
    private static final ResourceLocation WARNING_TEXTURE = new ResourceLocation("beyond_earth", "textures/overlay/warning.png");
    private static final ResourceLocation TIMER_1_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer1.png");
    private static final ResourceLocation TIMER_2_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer2.png");
    private static final ResourceLocation TIMER_3_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer3.png");
    private static final ResourceLocation TIMER_4_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer4.png");
    private static final ResourceLocation TIMER_5_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer5.png");
    private static final ResourceLocation TIMER_6_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer6.png");
    private static final ResourceLocation TIMER_7_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer7.png");
    private static final ResourceLocation TIMER_8_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer8.png");
    private static final ResourceLocation TIMER_9_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer9.png");
    private static final ResourceLocation TIMER_10_TEXTURE = new ResourceLocation("beyond_earth", "textures/timer/timer10.png");
    private static final ResourceLocation OXYGEN_TANK_EMPTY_TEXTURE = new ResourceLocation("beyond_earth", "textures/overlay/oxygen_tank_empty.png");
    private static final ResourceLocation OXYGEN_TANK_FULL_TEXTURE = new ResourceLocation("beyond_earth", "textures/overlay/oxygen_tank_full.png");
    private static final ResourceLocation MOON_PLANET_BAR_TEXTURE = new ResourceLocation("beyond_earth", "textures/planet_bar/moon_planet_bar.png");
    private static final ResourceLocation MARS_PLANET_BAR_TEXTURE = new ResourceLocation("beyond_earth", "textures/planet_bar/mars_planet_bar.png");
    private static final ResourceLocation MERCURY_PLANET_BAR_TEXTURE = new ResourceLocation("beyond_earth", "textures/planet_bar/mercury_planet_bar.png");
    private static final ResourceLocation VENUS_PLANET_BAR_TEXTURE = new ResourceLocation("beyond_earth", "textures/planet_bar/venus_planet_bar.png");
    private static final ResourceLocation GLACIO_PLANET_BAR_TEXTURE = new ResourceLocation("beyond_earth", "textures/planet_bar/glacio_planet_bar.png");
    private static final ResourceLocation EARTH_PLANET_BAR_TEXTURE = new ResourceLocation("beyond_earth", "textures/planet_bar/earth_planet_bar.png");
    private static final ResourceLocation ORBIT_PLANET_BAR_TEXTURE = new ResourceLocation("beyond_earth", "textures/planet_bar/orbit_planet_bar.png");
    private static final ResourceLocation ROCKET_PLANET_BAR_TEXTURE = new ResourceLocation("beyond_earth", "textures/planet_bar/rocket.png");
    public static IIngameOverlay WARNING = new IIngameOverlay(){

        public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
            Entity vehicle = Minecraft.m_91087_().f_91074_.m_20202_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)counter, (float)counter, (float)counter, (float)counter);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WARNING_TEXTURE);
            ForgeIngameGui.m_93133_((PoseStack)mStack, (int)(width / 2 - 58), (int)50, (float)0.0f, (float)0.0f, (int)116, (int)21, (int)116, (int)21);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double speed = (double)Math.round(100.0 * vehicle.m_20184_().m_7098_()) / 100.0;
            TranslatableComponent message = new TranslatableComponent("message.beyond_earth.speed", new Object[]{speed});
            Minecraft.m_91087_().f_91062_.m_92889_(mStack, (Component)message, (float)(width / 2 - 29), 80.0f, -3407872);
        }
    };
    public static IIngameOverlay ROCKET_TIMER = new IIngameOverlay(){

        public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
            Entity vehicle = Minecraft.m_91087_().f_91074_.m_20202_();
            int timer = 0;
            if (vehicle instanceof IRocketEntity) {
                timer = (Integer)vehicle.m_20088_().m_135370_(IRocketEntity.START_TIMER);
            }
            int timerWidth = width / 2 - 31;
            int timerHeight = height / 2 / 2;
            if (timer > -1 && timer < 20) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_10_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 20 && timer < 40) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_9_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 40 && timer < 60) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_8_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 60 && timer < 80) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_7_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 80 && timer < 100) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_6_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 100 && timer < 120) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_5_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 120 && timer < 140) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_4_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 140 && timer < 160) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_3_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 160 && timer < 180) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_2_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            } else if (timer > 180 && timer < 200) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TIMER_1_TEXTURE);
                ForgeIngameGui.m_93133_((PoseStack)mStack, (int)timerWidth, (int)timerHeight, (float)0.0f, (float)0.0f, (int)60, (int)38, (int)60, (int)38);
            }
        }
    };
    public static IIngameOverlay OXYGEN_TANK = new IIngameOverlay(){

        public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            IOxygenStorage oxygenStorage = (IOxygenStorage)chest.getCapability(CapabilityOxygen.OXYGEN).orElse(null);
            double oxygenStoredRatio = oxygenStorage != null ? oxygenStorage.getOxygenStoredRatio() : 0.0;
            int x = 5;
            int y = 5;
            int textureWidth = 62;
            int textureHeight = 52;
            GuiHelper.drawVerticalReverse(mStack, x, y, textureWidth, textureHeight, OXYGEN_TANK_EMPTY_TEXTURE, oxygenStoredRatio);
            GuiHelper.drawVertical(mStack, x, y, textureWidth, textureHeight, OXYGEN_TANK_FULL_TEXTURE, oxygenStoredRatio);
            if (oxygenStorage != null) {
                MutableComponent text = GaugeTextHelper.getPercentText(GaugeValueHelper.getOxygen(oxygenStorage)).build();
                int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text);
                Minecraft.m_91087_().f_91062_.m_92763_(mStack, (Component)text, (float)(x + (textureWidth - textWidth) / 2), (float)(y + textureHeight + 3), 0xFFFFFF);
            }
        }
    };
    public static IIngameOverlay ROCKET_HEIGHT = new IIngameOverlay(){

        public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            float yHeight = (float)player.m_20186_() / 5.3f;
            if (yHeight < 0.0f) {
                yHeight = 0.0f;
            } else if (yHeight > 113.0f) {
                yHeight = 113.0f;
            }
            ResourceLocation planet = Methods.isWorld((Level)world, Methods.moon) ? MOON_PLANET_BAR_TEXTURE : (Methods.isWorld((Level)world, Methods.mars) ? MARS_PLANET_BAR_TEXTURE : (Methods.isWorld((Level)world, Methods.mercury) ? MERCURY_PLANET_BAR_TEXTURE : (Methods.isWorld((Level)world, Methods.venus) ? VENUS_PLANET_BAR_TEXTURE : (Methods.isWorld((Level)world, Methods.glacio) ? GLACIO_PLANET_BAR_TEXTURE : (Methods.isOrbitWorld((Level)world) ? ORBIT_PLANET_BAR_TEXTURE : EARTH_PLANET_BAR_TEXTURE)))));
            RenderSystem.m_157456_((int)0, (ResourceLocation)planet);
            ForgeIngameGui.m_93133_((PoseStack)mStack, (int)0, (int)(height / 2 - 64), (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ROCKET_PLANET_BAR_TEXTURE);
            GuiHelper.blit(mStack, 4.0f, (float)(height / 2 + 51) - yHeight, 0.0f, 0.0f, 8.0f, 11.0f, 8, 11);
        }
    };

    @SubscribeEvent
    public static void overlayEnableOrDisable(RenderGameOverlayEvent.PostLayer event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Item chestItem = player.m_6844_(EquipmentSlot.CHEST).m_41720_();
        if (player.m_20202_() instanceof LanderEntity && !player.m_20202_().m_20096_() && !player.m_204029_(FluidTags.f_13131_)) {
            OverlayRegistry.enableOverlay((IIngameOverlay)WARNING, (boolean)true);
        } else {
            OverlayRegistry.enableOverlay((IIngameOverlay)WARNING, (boolean)false);
        }
        if (Methods.isRocket(player.m_20202_())) {
            OverlayRegistry.enableOverlay((IIngameOverlay)ROCKET_TIMER, (boolean)true);
        } else {
            OverlayRegistry.enableOverlay((IIngameOverlay)ROCKET_TIMER, (boolean)false);
        }
        if (chestItem == ItemsRegistry.SPACE_SUIT.get() || chestItem == ItemsRegistry.NETHERITE_SPACE_SUIT.get()) {
            OverlayRegistry.enableOverlay((IIngameOverlay)OXYGEN_TANK, (boolean)true);
        } else {
            OverlayRegistry.enableOverlay((IIngameOverlay)OXYGEN_TANK, (boolean)false);
        }
        if (Methods.isRocket(player.m_20202_()) || player.m_20202_() instanceof LanderEntity) {
            OverlayRegistry.enableOverlay((IIngameOverlay)ROCKET_HEIGHT, (boolean)true);
        } else {
            OverlayRegistry.enableOverlay((IIngameOverlay)ROCKET_HEIGHT, (boolean)false);
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (check) {
                if ((counter += 0.1f) > 1.0f) {
                    check = false;
                }
            } else if ((double)(counter -= 0.1f) < 0.2) {
                check = true;
            }
        }
    }
}

