/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.entities.alien;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.GoToPotentialJobSite;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAndFollowTradingPlayerSink;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PoiCompetitorScan;
import net.minecraft.world.entity.ai.behavior.ReactToBell;
import net.minecraft.world.entity.ai.behavior.SetRaidStatus;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.ValidateNearbyPoi;
import net.minecraft.world.entity.ai.behavior.VillagerGoalPackages;
import net.minecraft.world.entity.ai.behavior.VillagerPanicTrigger;
import net.minecraft.world.entity.ai.behavior.WakeUp;
import net.minecraft.world.entity.ai.behavior.YieldJobSite;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.mrscauthd.beyond_earth.config.Config;
import net.mrscauthd.beyond_earth.entities.AlienZombieEntity;
import net.mrscauthd.beyond_earth.entities.alien.AlienJobs;
import net.mrscauthd.beyond_earth.entities.alien.AlienTrade;
import net.mrscauthd.beyond_earth.registries.EntitiesRegistry;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;

public class AlienEntity
extends Villager
implements Merchant,
Npc {
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26360_, (Object)MemoryModuleType.f_26361_, (Object)MemoryModuleType.f_26362_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26366_, (Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26332_, (Object)MemoryModuleType.f_26370_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26371_, MemoryModuleType.f_26374_, MemoryModuleType.f_26375_, MemoryModuleType.f_26377_, MemoryModuleType.f_26379_, MemoryModuleType.f_26380_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26323_, MemoryModuleType.f_26363_, MemoryModuleType.f_26324_, MemoryModuleType.f_26325_, MemoryModuleType.f_26326_, MemoryModuleType.f_26328_, MemoryModuleType.f_26329_, MemoryModuleType.f_26330_, MemoryModuleType.f_26327_});
    private static final ImmutableList<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26813_, (Object)SensorType.f_26814_, (Object)SensorType.f_26815_, (Object)SensorType.f_26816_, (Object)SensorType.f_26817_, (Object)SensorType.f_26818_);

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super Villager>>> core(VillagerProfession profession, float p_220638_1_) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)Pair.of((Object)0, (Object)new InteractWithDoor()), (Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)0, (Object)new VillagerPanicTrigger()), (Object)Pair.of((Object)0, (Object)new WakeUp()), (Object)Pair.of((Object)0, (Object)new ReactToBell()), (Object)Pair.of((Object)0, (Object)new SetRaidStatus()), (Object)Pair.of((Object)0, (Object)new ValidateNearbyPoi(profession.m_35622_(), MemoryModuleType.f_26360_)), (Object)Pair.of((Object)0, (Object)new ValidateNearbyPoi(profession.m_35622_(), MemoryModuleType.f_26361_)), (Object)Pair.of((Object)1, (Object)new MoveToTargetSink()), (Object)Pair.of((Object)2, (Object)new PoiCompetitorScan(profession)), (Object)Pair.of((Object)3, (Object)new LookAndFollowTradingPlayerSink(p_220638_1_)), (Object[])new Pair[]{Pair.of((Object)5, (Object)new GoToWantedItem(p_220638_1_, false, 4)), Pair.of((Object)6, (Object)new AcquirePoi(profession.m_35622_(), MemoryModuleType.f_26360_, MemoryModuleType.f_26361_, true, Optional.empty())), Pair.of((Object)7, (Object)new GoToPotentialJobSite(p_220638_1_)), Pair.of((Object)8, (Object)new YieldJobSite(p_220638_1_)), Pair.of((Object)10, (Object)new AcquirePoi(PoiType.f_27346_, MemoryModuleType.f_26359_, false, Optional.of((byte)14))), Pair.of((Object)10, (Object)new AcquirePoi(PoiType.f_27347_, MemoryModuleType.f_26362_, true, Optional.of((byte)14)))});
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 48.0);
    }

    public AlienEntity(EntityType<? extends Villager> type, Level worldIn) {
        super(type, worldIn);
    }

    public Villager m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        AlienEntity alienentity = new AlienEntity((EntityType<? extends Villager>)((EntityType)EntitiesRegistry.ALIEN.get()), this.f_19853_);
        alienentity.m_6518_((ServerLevelAccessor)p_241840_1_, p_241840_1_.m_6436_(new BlockPos(p_241840_2_.m_20185_(), p_241840_2_.m_20186_(), p_241840_2_.m_20189_())), MobSpawnType.BREEDING, null, null);
        return alienentity;
    }

    public void m_8038_(ServerLevel p_35409_, LightningBolt p_35410_) {
        this.m_7311_(this.m_20094_() + 1);
        if (this.m_20094_() == 0) {
            this.m_20254_(8);
        }
        super.m_8038_(p_35409_, p_35410_);
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (itemstack.m_41720_() != ItemsRegistry.ALIEN_SPAWN_EGG.get() && this.m_6084_() && !this.m_35306_() && !this.m_5803_() && !p_230254_1_.m_36341_()) {
            if (this.m_6162_()) {
                this.shakeHead();
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            boolean flag = this.m_6616_().isEmpty();
            if (p_230254_2_ == InteractionHand.MAIN_HAND) {
                if (flag && !this.f_19853_.f_46443_) {
                    this.shakeHead();
                }
                p_230254_1_.m_36220_(Stats.f_12940_);
            }
            if (flag) {
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.f_19853_.f_46443_ && !this.f_35261_.isEmpty()) {
                this.displayMerchantGui(p_230254_1_);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private void displayMerchantGui(Player player) {
        this.recalculateSpecialPricesFor(player);
        this.m_7189_(player);
        this.m_45301_(player, this.m_5446_(), this.m_7141_().m_35576_());
    }

    private void recalculateSpecialPricesFor(Player playerIn) {
        int i = this.m_35532_(playerIn);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45353_((int)(-Math.floor((float)i * merchantoffer.m_45378_())));
            }
        }
        if (playerIn.m_21023_(MobEffects.f_19595_)) {
            MobEffectInstance effectinstance = playerIn.m_21124_(MobEffects.f_19595_);
            int k = effectinstance.m_19564_();
            for (MerchantOffer merchantoffer1 : this.m_6616_()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantoffer1.m_45352_().m_41613_());
                merchantoffer1.m_45353_(-Math.max(j, 1));
            }
        }
    }

    private void shakeHead() {
        this.m_35319_(40);
        if (!this.f_19853_.f_46443_) {
            this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
        }
    }

    protected Brain<?> m_8075_(Dynamic<?> p_35445_) {
        Brain brain = Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES).m_22073_(p_35445_);
        this.initBrain((Brain<Villager>)brain);
        return brain;
    }

    public void m_35483_(ServerLevel p_35484_) {
        Brain brain = this.m_6274_();
        brain.m_21933_(p_35484_, (LivingEntity)this);
        this.f_20939_ = brain.m_21973_();
        this.initBrain((Brain<Villager>)this.m_6274_());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AlienZombieEntity.class, 15.0f, 0.5, 0.5));
    }

    private void initBrain(Brain<Villager> p_35425_) {
        VillagerProfession villagerprofession = this.m_7141_().m_35571_();
        if (this.m_6162_()) {
            p_35425_.m_21912_(Schedule.f_38014_);
            p_35425_.m_21900_(Activity.f_37981_, VillagerGoalPackages.m_24583_((float)0.5f));
        } else {
            p_35425_.m_21912_(Schedule.f_38015_);
            p_35425_.m_21903_(Activity.f_37980_, VillagerGoalPackages.m_24589_((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26360_, (Object)MemoryStatus.VALUE_PRESENT)));
        }
        p_35425_.m_21900_(Activity.f_37978_, AlienEntity.core(villagerprofession, 0.5f));
        p_35425_.m_21900_(Activity.f_37982_, VillagerGoalPackages.m_24592_((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.m_21900_(Activity.f_37979_, VillagerGoalPackages.m_24598_((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.m_21900_(Activity.f_37984_, VillagerGoalPackages.m_24601_((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.m_21900_(Activity.f_37986_, VillagerGoalPackages.m_24604_((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.m_21900_(Activity.f_37985_, VillagerGoalPackages.m_24607_((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.m_21900_(Activity.f_37987_, VillagerGoalPackages.m_24610_((VillagerProfession)villagerprofession, (float)0.5f));
        p_35425_.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        p_35425_.m_21944_(Activity.f_37979_);
        p_35425_.m_21889_(Activity.f_37979_);
        p_35425_.m_21862_(this.f_19853_.m_46468_(), this.f_19853_.m_46467_());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.COMMAND || reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.SPAWNER || reason == MobSpawnType.DISPENSER) {
            this.m_141967_(this.m_7141_().m_35567_(VillagerType.m_204073_((Holder)worldIn.m_204166_(this.m_142538_()))));
        }
        if (reason == MobSpawnType.STRUCTURE) {
            this.f_35366_ = true;
        }
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(false);
        }
        int max = 13;
        int min = 1;
        for (int i = 0; i < new Random().nextInt(max + 1 - min) + min; ++i) {
            AlienJobs j = AlienJobs.values()[i];
            this.m_141967_(this.m_7141_().m_35565_(j.getAlienJobs()));
        }
        return spawnDataIn;
    }

    public void m_35397_(ServerLevel p_35398_, long p_35399_, int p_35400_) {
    }

    protected void m_7604_() {
        VillagerTrades.ItemListing[] avillagertrades$itrade;
        VillagerData villagerdata = this.m_7141_();
        Int2ObjectMap<VillagerTrades.ItemListing[]> int2objectmap = AlienTrade.TRADES.get(villagerdata.m_35571_());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$itrade = (VillagerTrades.ItemListing[])int2objectmap.get(villagerdata.m_35576_())) != null) {
            MerchantOffers merchantoffers = this.m_6616_();
            this.m_35277_(merchantoffers, avillagertrades$itrade, 6);
        }
    }

    protected void m_35277_(MerchantOffers p_35278_, VillagerTrades.ItemListing[] p_35279_, int p_35280_) {
        HashSet set = Sets.newHashSet();
        if (p_35279_.length > p_35280_) {
            while (set.size() < p_35280_) {
                set.add(this.f_19796_.nextInt(p_35279_.length));
            }
        } else {
            for (int i = 0; i < p_35279_.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing villagertrades$itemlisting = p_35279_[integer];
            MerchantOffer merchantoffer = villagertrades$itemlisting.m_5670_((Entity)this, this.f_19796_);
            if (merchantoffer == null) continue;
            p_35278_.add((Object)merchantoffer);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (!((Boolean)Config.ALIEN_SPAWN.get()).booleanValue()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

