/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class IngredientStack {
    public static IngredientStack EMPTY = new IngredientStack(Ingredient.f_43901_);
    private final Ingredient ingredient;
    private int count = 1;

    public IngredientStack(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)json;
            this.ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient"));
            this.count = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"count", (int)this.count);
        } else {
            this.ingredient = json instanceof JsonArray ? Ingredient.m_43917_((JsonElement)json) : Ingredient.f_43901_;
        }
    }

    public IngredientStack(FriendlyByteBuf buffer) {
        this.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        this.count = buffer.readInt();
    }

    public IngredientStack(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public IngredientStack(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    public ItemStack[] getItems() {
        int count = this.getCount();
        return (ItemStack[])Arrays.stream(this.getIngredient().m_43908_()).map(is -> {
            is.m_41764_(count);
            return is;
        }).toArray(ItemStack[]::new);
    }

    public boolean testWithoutCount(ItemStack itemStack) {
        return this.getIngredient().test(itemStack);
    }

    public boolean testWithCount(ItemStack itemStack) {
        return this.testWithoutCount(itemStack) && itemStack.m_41613_() >= this.getCount();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeInt(this.count);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("ingredient", this.ingredient.m_43942_());
        json.addProperty("count", (Number)this.count);
        return json;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public IngredientStack copy() {
        return new IngredientStack(this.getIngredient(), this.getCount());
    }
}

