/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.crafting;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.crafting.AlienTradingRecipeItemStack;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeSerializer;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeTypes;
import net.mrscauthd.beyond_earth.registries.RecipeSerializersRegistry;

public class AlienTradingRecipePotionedItem
extends AlienTradingRecipeItemStack {
    public AlienTradingRecipePotionedItem(ResourceLocation id, JsonObject json) {
        super(id, json);
    }

    public AlienTradingRecipePotionedItem(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
    }

    @Override
    public ItemStack getResult(Entity trader, Random rand) {
        ItemStack result = super.getResult(trader, rand);
        List potions = ForgeRegistries.POTIONS.getValues().stream().filter(this::testPotion).collect(Collectors.toList());
        Potion potion = (Potion)potions.get(rand.nextInt(potions.size()));
        return PotionUtils.m_43549_((ItemStack)result, (Potion)potion);
    }

    public boolean testPotion(Potion potion) {
        return !potion.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)potion);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.RECIPE_SERIALIZER_ALIEN_TRADING_POTIONED_ITEM.get();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return BeyondEarthRecipeTypes.ALIEN_TRADING_POTIONED_ITEM;
    }

    public static class Serializer
    extends BeyondEarthRecipeSerializer<AlienTradingRecipePotionedItem> {
        public AlienTradingRecipePotionedItem fromJson(ResourceLocation id, JsonObject json) {
            return new AlienTradingRecipePotionedItem(id, json);
        }

        public AlienTradingRecipePotionedItem fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new AlienTradingRecipePotionedItem(id, buffer);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlienTradingRecipePotionedItem recipe) {
            recipe.write(buffer);
        }
    }
}

