/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.concurrent.locks.StampedLock;
import net.caffeinemc.phosphor.common.chunk.light.IReadonly;
import net.caffeinemc.phosphor.common.chunk.light.LevelPropagatorAccess;
import net.caffeinemc.phosphor.common.chunk.light.LightProviderUpdateTracker;
import net.caffeinemc.phosphor.common.chunk.light.LightStorageAccess;
import net.caffeinemc.phosphor.common.util.chunk.light.EmptyChunkNibbleArray;
import net.caffeinemc.phosphor.common.util.math.ChunkSectionPosHelper;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.SectionTracker;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LayerLightSectionStorage.class})
public abstract class MixinLightStorage
extends SectionTracker
implements LightStorageAccess {
    @Shadow
    @Final
    protected DataLayerStorageMap<?> f_75732_;
    @Mutable
    @Shadow
    @Final
    protected LongSet f_75733_;
    @Mutable
    @Shadow
    @Final
    protected LongSet f_75734_;
    @Mutable
    @Shadow
    @Final
    protected LongSet f_75728_;
    @Mutable
    @Shadow
    @Final
    protected LongSet f_75730_;
    @Mutable
    @Shadow
    @Final
    protected LongSet f_75729_;
    @Shadow
    protected volatile boolean f_75736_;
    @Shadow
    protected volatile DataLayerStorageMap<?> f_75731_;
    @Shadow
    @Final
    protected Long2ObjectMap<DataLayer> f_75735_;
    @Shadow
    @Final
    private static Direction[] f_75737_;
    @Shadow
    @Final
    private LightChunkGetter f_75739_;
    @Shadow
    @Final
    private LightLayer f_75738_;
    @Shadow
    @Final
    private LongSet f_75740_;
    @Unique
    private final Long2ObjectMap<Int2ByteMap> trackedSectionsByChunk = new Long2ObjectOpenHashMap();
    @Unique
    protected final StampedLock uncachedLightArraysLock = new StampedLock();
    @Unique
    protected final LongSet enabledChunks = new LongOpenHashSet();
    @Unique
    protected final Long2IntMap lightmapComplexities = (Long2IntMap)Util.m_137469_((Object)new Long2IntOpenHashMap(), map -> map.defaultReturnValue(-1));
    @Unique
    private final LongSet markedEnabledChunks = new LongOpenHashSet();
    @Unique
    private final LongSet trivialLightmaps = new LongOpenHashSet();
    @Unique
    private final LongSet vanillaLightmapsToRemove = new LongOpenHashSet();
    @Unique
    protected final LongSet nonOptimizableSections = new LongOpenHashSet();

    protected MixinLightStorage() {
        super(0, 0, 0);
    }

    @Shadow
    protected abstract int m_6172_(long var1);

    @Shadow
    protected abstract void m_6177_(long var1);

    @Shadow
    protected abstract DataLayer m_7667_(long var1);

    @Shadow
    protected abstract boolean m_6808_();

    @Shadow
    protected abstract void m_6187_(long var1);

    @Shadow
    protected abstract void m_75764_(LayerLightEngine<?, ?> var1, long var2);

    @Shadow
    protected abstract DataLayer m_75758_(long var1, boolean var3);

    @Unique
    protected void trackSection(long sectionPos) {
        this.trackSection(SectionPos.m_123240_((long)sectionPos), SectionPos.m_123225_((long)sectionPos));
    }

    @Unique
    protected void trackSection(long chunkPos, int y) {
        Int2ByteMap sections = (Int2ByteMap)this.trackedSectionsByChunk.computeIfAbsent(chunkPos, __ -> new Int2ByteOpenHashMap());
        sections.put(y, (byte)(sections.get(y) + 1));
    }

    @Unique
    protected void untrackSection(long sectionPos) {
        this.untrackSection(SectionPos.m_123240_((long)sectionPos), SectionPos.m_123225_((long)sectionPos));
    }

    @Unique
    protected void untrackSection(long chunkPos, int y) {
        Int2ByteMap sections = (Int2ByteMap)this.trackedSectionsByChunk.get(chunkPos);
        byte count = (byte)(sections.get(y) - 1);
        if (count == 0) {
            sections.remove(y);
            if (sections.isEmpty()) {
                this.trackedSectionsByChunk.remove(chunkPos);
            }
        } else {
            sections.put(y, count);
        }
    }

    @Unique
    protected IntIterator getTrackedSections(long chunkPos) {
        Int2ByteMap sections = (Int2ByteMap)this.trackedSectionsByChunk.get(chunkPos);
        return sections == null ? IntIterators.EMPTY_ITERATOR : IntIterators.wrap((int[])sections.keySet().toIntArray());
    }

    @Overwrite
    public int m_75795_(long blockPos) {
        int x = BlockPos.m_121983_((long)blockPos);
        int y = BlockPos.m_122008_((long)blockPos);
        int z = BlockPos.m_122015_((long)blockPos);
        long chunk = SectionPos.m_123209_((int)SectionPos.m_123171_((int)x), (int)SectionPos.m_123171_((int)y), (int)SectionPos.m_123171_((int)z));
        DataLayer array = this.m_75758_(chunk, true);
        if (array == null) {
            return this.getLightWithoutLightmap(blockPos);
        }
        return array.m_62560_(SectionPos.m_123207_((int)x), SectionPos.m_123207_((int)y), SectionPos.m_123207_((int)z));
    }

    @Overwrite
    public void m_75772_(long blockPos, int value) {
        int x = BlockPos.m_121983_((long)blockPos);
        int y = BlockPos.m_122008_((long)blockPos);
        int z = BlockPos.m_122015_((long)blockPos);
        long chunkPos = SectionPos.m_123209_((int)(x >> 4), (int)(y >> 4), (int)(z >> 4));
        DataLayer lightmap = this.getOrAddLightmap(chunkPos);
        int oldVal = lightmap.m_62560_(x & 0xF, y & 0xF, z & 0xF);
        this.beforeLightChange(blockPos, oldVal, value, lightmap);
        this.changeLightmapComplexity(chunkPos, this.getLightmapComplexityChange(blockPos, oldVal, value, lightmap));
        if (this.f_75733_.add(chunkPos)) {
            this.f_75732_.m_75524_(chunkPos);
        }
        DataLayer nibble = this.m_75758_(chunkPos, true);
        nibble.m_62564_(x & 0xF, y & 0xF, z & 0xF, value);
        for (int z2 = z - 1 >> 4; z2 <= z + 1 >> 4; ++z2) {
            for (int x2 = x - 1 >> 4; x2 <= x + 1 >> 4; ++x2) {
                for (int y2 = y - 1 >> 4; y2 <= y + 1 >> 4; ++y2) {
                    this.f_75734_.add(SectionPos.m_123209_((int)x2, (int)y2, (int)z2));
                }
            }
        }
    }

    @Overwrite
    public void m_7351_(long id, int level) {
        int oldLevel = this.m_6172_(id);
        if (oldLevel != 0 && level == 0) {
            this.f_75728_.add(id);
            this.f_75730_.remove(id);
        }
        if (oldLevel == 0 && level != 0) {
            this.f_75728_.remove(id);
            this.f_75729_.remove(id);
            this.untrackSection(id);
        }
        if (oldLevel >= 2 && level < 2) {
            this.nonOptimizableSections.add(id);
            if (this.enabledChunks.contains(SectionPos.m_123240_((long)id))) {
                if (!this.vanillaLightmapsToRemove.remove(id)) {
                    if (this.m_75758_(id, true) == null) {
                        this.f_75732_.m_75526_(id, this.createTrivialVanillaLightmap(id));
                        this.f_75733_.add(id);
                        this.f_75732_.m_75531_();
                    }
                    this.trackSection(id);
                }
            } else {
                this.trackSection(id);
            }
        }
        if (oldLevel < 2 && level >= 2) {
            this.nonOptimizableSections.remove(id);
            if (this.enabledChunks.contains(SectionPos.m_123240_((long)id))) {
                DataLayer lightmap = this.m_75758_(id, true);
                if (lightmap != null && ((IReadonly)lightmap).isReadonly()) {
                    this.vanillaLightmapsToRemove.add(id);
                    this.markForLightUpdates();
                } else {
                    this.untrackSection(id);
                }
            } else {
                this.untrackSection(id);
            }
        }
    }

    @Inject(method={"removeSection"}, at={@At(value="HEAD")}, cancellable=true)
    protected void preRemoveSection(LayerLightEngine<?, ?> provider, long pos, CallbackInfo ci) {
        if (provider instanceof LightProviderUpdateTracker) {
            ((LightProviderUpdateTracker)provider).cancelUpdatesForChunk(pos);
            ci.cancel();
        }
    }

    @Override
    public void runCleanups() {
        this.runCleanups(null);
    }

    @Unique
    protected void runCleanups(LayerLightEngine<?, ?> lightProvider) {
        if (!this.f_75736_) {
            return;
        }
        this.removeTrivialLightmaps(lightProvider);
        this.removeVanillaLightmaps(lightProvider);
        if (lightProvider == null) {
            this.checkForUpdates();
        }
    }

    @Overwrite
    public void m_6716_(LayerLightEngine<?, ?> lightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        if (!this.m_6808_()) {
            return;
        }
        this.initializeChunks();
        this.addQueuedLightmaps(lightProvider);
        this.runCleanups(lightProvider);
        LongIterator it = !skipEdgeLightPropagation ? this.f_75735_.keySet().iterator() : this.f_75740_.iterator();
        while (it.hasNext()) {
            this.m_75777_(lightProvider, it.nextLong());
        }
        this.f_75740_.clear();
        this.f_75735_.clear();
        this.f_75736_ = false;
    }

    @Overwrite
    private void m_75777_(LayerLightEngine<?, ?> chunkLightProvider, long pos) {
        if (this.m_75791_(pos)) {
            LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)chunkLightProvider;
            int x = SectionPos.m_123223_((int)SectionPos.m_123213_((long)pos));
            int y = SectionPos.m_123223_((int)SectionPos.m_123225_((long)pos));
            int z = SectionPos.m_123223_((int)SectionPos.m_123230_((long)pos));
            for (Direction dir : f_75737_) {
                long adjPos = SectionPos.m_123191_((long)pos, (Direction)dir);
                if (this.f_75735_.containsKey(adjPos) || !this.m_75791_(adjPos)) continue;
                for (int u1 = 0; u1 < 16; ++u1) {
                    block10: for (int u2 = 0; u2 < 16; ++u2) {
                        long b;
                        long a;
                        switch (dir) {
                            case DOWN: {
                                a = BlockPos.m_121882_((int)(x + u2), (int)y, (int)(z + u1));
                                b = BlockPos.m_121882_((int)(x + u2), (int)(y - 1), (int)(z + u1));
                                break;
                            }
                            case UP: {
                                a = BlockPos.m_121882_((int)(x + u2), (int)(y + 15), (int)(z + u1));
                                b = BlockPos.m_121882_((int)(x + u2), (int)(y + 16), (int)(z + u1));
                                break;
                            }
                            case NORTH: {
                                a = BlockPos.m_121882_((int)(x + u1), (int)(y + u2), (int)z);
                                b = BlockPos.m_121882_((int)(x + u1), (int)(y + u2), (int)(z - 1));
                                break;
                            }
                            case SOUTH: {
                                a = BlockPos.m_121882_((int)(x + u1), (int)(y + u2), (int)(z + 15));
                                b = BlockPos.m_121882_((int)(x + u1), (int)(y + u2), (int)(z + 16));
                                break;
                            }
                            case WEST: {
                                a = BlockPos.m_121882_((int)x, (int)(y + u1), (int)(z + u2));
                                b = BlockPos.m_121882_((int)(x - 1), (int)(y + u1), (int)(z + u2));
                                break;
                            }
                            case EAST: {
                                a = BlockPos.m_121882_((int)(x + 15), (int)(y + u1), (int)(z + u2));
                                b = BlockPos.m_121882_((int)(x + 16), (int)(y + u1), (int)(z + u2));
                                break;
                            }
                            default: {
                                continue block10;
                            }
                        }
                        levelPropagator.propagateLevel(a, b, false);
                        levelPropagator.propagateLevel(b, a, false);
                    }
                }
            }
            levelPropagator.checkForUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void m_75790_() {
        if (!this.f_75733_.isEmpty()) {
            long stamp = this.uncachedLightArraysLock.writeLock();
            try {
                DataLayerStorageMap map = this.f_75732_.m_5972_();
                map.m_75534_();
                this.f_75731_ = map;
            }
            finally {
                this.uncachedLightArraysLock.unlockWrite(stamp);
            }
            this.f_75733_.clear();
        }
        if (!this.f_75734_.isEmpty()) {
            LongIterator it = this.f_75734_.iterator();
            while (it.hasNext()) {
                long pos = it.nextLong();
                this.f_75739_.m_6506_(this.f_75738_, SectionPos.m_123184_((long)pos));
            }
            this.f_75734_.clear();
        }
    }

    @Unique
    protected int getLightWithoutLightmap(long blockPos) {
        return 0;
    }

    @Unique
    protected void beforeChunkEnabled(long chunkPos) {
        IntIterator it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            long sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt());
            if (!this.hasLightmap(sectionPos)) continue;
            this.m_6177_(sectionPos);
        }
    }

    @Unique
    protected void afterChunkDisabled(long chunkPos, IntIterable removedLightmaps) {
        IntIterator it = removedLightmaps.iterator();
        while (it.hasNext()) {
            this.m_6187_(ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt()));
        }
    }

    @Unique
    protected DataLayer getOrAddLightmap(long sectionPos) {
        DataLayer lightmap = this.m_75758_(sectionPos, true);
        if (lightmap == null) {
            lightmap = this.m_7667_(sectionPos);
        } else if (((IReadonly)lightmap).isReadonly()) {
            lightmap = lightmap.m_62569_();
            if (this.vanillaLightmapsToRemove.remove(sectionPos)) {
                this.untrackSection(sectionPos);
            }
        } else {
            return lightmap;
        }
        this.f_75732_.m_75526_(sectionPos, lightmap);
        this.trackSection(sectionPos);
        this.f_75733_.add(sectionPos);
        this.f_75732_.m_75531_();
        this.m_6177_(sectionPos);
        this.setLightmapComplexity(sectionPos, 0);
        return lightmap;
    }

    @Unique
    protected void setLightmapComplexity(long sectionPos, int complexity) {
        int oldComplexity = this.lightmapComplexities.put(sectionPos, complexity);
        if (oldComplexity == 0) {
            this.trivialLightmaps.remove(sectionPos);
        }
        if (complexity == 0) {
            this.trivialLightmaps.add(sectionPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    private void checkForUpdates() {
        this.f_75736_ = !this.trivialLightmaps.isEmpty() || !this.vanillaLightmapsToRemove.isEmpty() || !this.markedEnabledChunks.isEmpty() || !this.f_75735_.isEmpty();
    }

    @Unique
    private void markForLightUpdates() {
        if (!this.f_75736_) {
            this.f_75736_ = true;
        }
    }

    @Unique
    protected void changeLightmapComplexity(long sectionPos, int amount) {
        int complexity = this.lightmapComplexities.get(sectionPos);
        if (complexity == 0) {
            this.trivialLightmaps.remove(sectionPos);
        }
        this.lightmapComplexities.put(sectionPos, complexity += amount);
        if (complexity == 0) {
            this.trivialLightmaps.add(sectionPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    protected DataLayer getLightmap(long sectionPos) {
        DataLayer lightmap = this.m_75758_(sectionPos, true);
        return lightmap == null || ((IReadonly)lightmap).isReadonly() ? null : lightmap;
    }

    @Unique
    protected boolean hasLightmap(long sectionPos) {
        return this.getLightmap(sectionPos) != null;
    }

    @Unique
    protected void beforeLightChange(long blockPos, int oldVal, int newVal, DataLayer lightmap) {
    }

    @Unique
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, DataLayer lightmap) {
        return 0;
    }

    @Unique
    protected void beforeLightmapChange(long sectionPos, DataLayer oldLightmap, DataLayer newLightmap) {
    }

    @Unique
    protected int getInitialLightmapComplexity(long sectionPos, DataLayer lightmap) {
        return 0;
    }

    @Override
    @Invoker(value="hasSection")
    public abstract boolean callHasSection(long var1);

    @Overwrite
    public boolean m_75791_(long sectionPos) {
        return this.enabledChunks.contains(SectionPos.m_123240_((long)sectionPos));
    }

    @Shadow
    protected abstract void m_7358_(long var1, boolean var3);

    @Overwrite
    public void m_75787_(long sectionPos, boolean notReady) {
        if (notReady) {
            if (this.f_75730_.remove(sectionPos)) {
                this.untrackSection(sectionPos);
            } else if (!this.f_75728_.contains(sectionPos) || !this.f_75729_.add(sectionPos)) {
                return;
            }
            this.m_75576_(Long.MAX_VALUE, sectionPos, 2, false);
        } else {
            if (!this.f_75729_.remove(sectionPos)) {
                if (this.f_75728_.contains(sectionPos) || !this.f_75730_.add(sectionPos)) {
                    return;
                }
                this.trackSection(sectionPos);
            }
            this.m_75576_(Long.MAX_VALUE, sectionPos, 0, true);
        }
    }

    @Override
    @Invoker(value="setColumnEnabled")
    public abstract void invokeSetColumnEnabled(long var1, boolean var3);

    @Override
    public void enableLightUpdates(long chunkPos) {
        if (!this.enabledChunks.contains(chunkPos)) {
            this.markedEnabledChunks.add(chunkPos);
            this.markForLightUpdates();
        }
    }

    @Unique
    private void initializeChunks() {
        this.f_75732_.m_75531_();
        LongIterator cit = this.markedEnabledChunks.iterator();
        while (cit.hasNext()) {
            long sectionPos;
            long chunkPos = cit.nextLong();
            this.beforeChunkEnabled(chunkPos);
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                sectionPos = SectionPos.m_123209_((int)SectionPos.m_123213_((long)chunkPos), (int)it.nextInt(), (int)SectionPos.m_123230_((long)chunkPos));
                if (!this.hasLightmap(sectionPos)) continue;
                this.setLightmapComplexity(sectionPos, this.getInitialLightmapComplexity(sectionPos, this.m_75758_(sectionPos, true)));
            }
            it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                sectionPos = SectionPos.m_123209_((int)SectionPos.m_123213_((long)chunkPos), (int)it.nextInt(), (int)SectionPos.m_123230_((long)chunkPos));
                if (!this.nonOptimizableSections.contains(sectionPos) || this.m_75758_(sectionPos, true) != null) continue;
                this.f_75732_.m_75526_(sectionPos, this.createInitialVanillaLightmap(sectionPos));
                this.f_75733_.add(sectionPos);
            }
            this.enabledChunks.add(chunkPos);
        }
        this.f_75732_.m_75531_();
        this.markedEnabledChunks.clear();
    }

    @Unique
    protected DataLayer createInitialVanillaLightmap(long sectionPos) {
        return this.createTrivialVanillaLightmap(sectionPos);
    }

    @Unique
    protected DataLayer createTrivialVanillaLightmap(long sectionPos) {
        return new EmptyChunkNibbleArray();
    }

    @Override
    public void disableChunkLight(long chunkPos, LayerLightEngine<?, ?> lightProvider) {
        if (this.markedEnabledChunks.remove(chunkPos) || !this.enabledChunks.contains(chunkPos)) {
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                int y = it.nextInt();
                long sectionPos2 = SectionPos.m_123209_((int)SectionPos.m_123213_((long)chunkPos), (int)y, (int)SectionPos.m_123230_((long)chunkPos));
                if (this.f_75732_.m_75535_(sectionPos2) == null) continue;
                this.untrackSection(chunkPos, y);
                this.f_75733_.add(sectionPos2);
            }
            this.m_7358_(chunkPos, false);
            this.removeBlockData(chunkPos);
        } else {
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                long sectionPos3 = SectionPos.m_123209_((int)SectionPos.m_123213_((long)chunkPos), (int)it.nextInt(), (int)SectionPos.m_123230_((long)chunkPos));
                if (!this.m_75791_(sectionPos3)) continue;
                this.m_75764_(lightProvider, sectionPos3);
            }
            this.enabledChunks.remove(chunkPos);
            IntArrayList removedLightmaps = new IntArrayList();
            IntIterator it2 = this.getTrackedSections(chunkPos);
            while (it2.hasNext()) {
                int y = it2.nextInt();
                long sectionPos4 = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                if (!this.removeLightmap(sectionPos4)) continue;
                removedLightmaps.add(y);
            }
            this.f_75735_.keySet().removeIf(sectionPos -> SectionPos.m_123240_((long)sectionPos) == chunkPos);
            this.f_75740_.removeIf(sectionPos -> SectionPos.m_123240_((long)sectionPos) == chunkPos);
            this.f_75732_.m_75531_();
            this.m_7358_(chunkPos, false);
            this.afterChunkDisabled(chunkPos, (IntIterable)removedLightmaps);
            this.removeBlockData(chunkPos);
        }
    }

    @Unique
    protected boolean removeLightmap(long sectionPos) {
        if (this.f_75732_.m_75535_(sectionPos) == null) {
            return false;
        }
        this.f_75733_.add(sectionPos);
        if (this.lightmapComplexities.remove(sectionPos) == -1) {
            if (this.vanillaLightmapsToRemove.remove(sectionPos)) {
                this.untrackSection(sectionPos);
            }
            return false;
        }
        this.trivialLightmaps.remove(sectionPos);
        this.untrackSection(sectionPos);
        return true;
    }

    @Unique
    private void removeBlockData(long chunkPos) {
        IntIterator it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            this.m_75787_(ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt()), true);
        }
    }

    @Unique
    private void removeTrivialLightmaps(LayerLightEngine<?, ?> lightProvider) {
        long sectionPos;
        LongIterator it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            this.f_75732_.m_75535_(sectionPos);
            this.lightmapComplexities.remove(sectionPos);
            this.untrackSection(sectionPos);
            this.f_75733_.add(sectionPos);
        }
        this.f_75732_.m_75531_();
        it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            this.m_6187_(it.nextLong());
        }
        it = this.trivialLightmaps.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            if (!this.nonOptimizableSections.contains(sectionPos)) continue;
            this.f_75732_.m_75526_(sectionPos, this.createTrivialVanillaLightmap(sectionPos));
        }
        this.f_75732_.m_75531_();
        if (lightProvider != null) {
            it = this.trivialLightmaps.iterator();
            while (it.hasNext()) {
                sectionPos = it.nextLong();
                if (this.m_75791_(sectionPos)) continue;
                this.m_75764_(lightProvider, sectionPos);
            }
        }
        this.trivialLightmaps.clear();
    }

    @Unique
    private void removeVanillaLightmaps(LayerLightEngine<?, ?> lightProvider) {
        long sectionPos;
        LongIterator it = this.vanillaLightmapsToRemove.iterator();
        while (it.hasNext()) {
            sectionPos = it.nextLong();
            this.f_75732_.m_75535_(sectionPos);
            this.untrackSection(sectionPos);
            this.f_75733_.add(sectionPos);
        }
        this.f_75732_.m_75531_();
        if (lightProvider != null) {
            it = this.vanillaLightmapsToRemove.iterator();
            while (it.hasNext()) {
                sectionPos = it.nextLong();
                if (this.m_75791_(sectionPos)) continue;
                this.m_75764_(lightProvider, sectionPos);
            }
        }
        this.vanillaLightmapsToRemove.clear();
    }

    @Unique
    private void addQueuedLightmaps(LayerLightEngine<?, ?> lightProvider) {
        ObjectIterator it = Long2ObjectMaps.fastIterator(this.f_75735_);
        while (it.hasNext()) {
            DataLayer oldLightmap;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long sectionPos = entry.getLongKey();
            DataLayer lightmap = (DataLayer)entry.getValue();
            if (lightmap == (oldLightmap = this.getLightmap(sectionPos))) continue;
            this.m_75764_(lightProvider, sectionPos);
            this.beforeLightmapChange(sectionPos, oldLightmap, lightmap);
            this.f_75732_.m_75526_(sectionPos, lightmap);
            this.f_75732_.m_75531_();
            this.f_75733_.add(sectionPos);
            if (oldLightmap == null) {
                this.trackSection(sectionPos);
                this.m_6177_(sectionPos);
            }
            if (this.vanillaLightmapsToRemove.remove(sectionPos)) {
                this.untrackSection(sectionPos);
            }
            this.setLightmapComplexity(sectionPos, this.getInitialLightmapComplexity(sectionPos, lightmap));
        }
    }

    @Overwrite
    public void m_75754_(long sectionPos, DataLayer array, boolean bl) {
        boolean chunkEnabled = this.enabledChunks.contains(SectionPos.m_123240_((long)sectionPos));
        if (array != null) {
            if (chunkEnabled) {
                this.f_75735_.put(sectionPos, (Object)array);
                this.markForLightUpdates();
            } else {
                this.f_75732_.m_75526_(sectionPos, array);
                this.trackSection(sectionPos);
                this.f_75733_.add(sectionPos);
            }
            if (!bl) {
                this.f_75740_.add(sectionPos);
            }
        } else if (chunkEnabled) {
            this.f_75735_.remove(sectionPos);
        } else if (this.f_75732_.m_75535_(sectionPos) != null) {
            this.untrackSection(sectionPos);
            this.f_75733_.add(sectionPos);
        }
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/chunk/light/LightStorage;queuedSections:Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", opcode=180)), at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", ordinal=0, remap=false))
    private Object cancelLightmapLookupFromQueue(Long2ObjectMap<DataLayer> lightmapArray, long pos) {
        return null;
    }

    @Redirect(method={"getLevel(J)I"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/chunk/light/LightStorage;storage:Lnet/minecraft/world/chunk/ChunkToNibbleArrayMap;", opcode=180)), at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/ChunkToNibbleArrayMap;containsKey(J)Z", ordinal=0))
    private boolean isNonOptimizable(DataLayerStorageMap<?> lightmapArray, long sectionPos) {
        return this.nonOptimizableSections.contains(sectionPos);
    }
}

