/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.common;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.config.enums.BreakMode;
import fr.raksrinana.fallingtree.common.leaf.LeafBreakingHandler;
import fr.raksrinana.fallingtree.common.wrapper.DirectionCompat;
import fr.raksrinana.fallingtree.common.wrapper.IBlock;
import fr.raksrinana.fallingtree.common.wrapper.IBlockPos;
import fr.raksrinana.fallingtree.common.wrapper.IBlockState;
import fr.raksrinana.fallingtree.common.wrapper.IComponent;
import fr.raksrinana.fallingtree.common.wrapper.IEnchantment;
import fr.raksrinana.fallingtree.common.wrapper.IItem;
import fr.raksrinana.fallingtree.common.wrapper.ILevel;
import fr.raksrinana.fallingtree.common.wrapper.IPlayer;
import fr.raksrinana.fallingtree.fabric.common.wrapper.BlockWrapper;
import fr.raksrinana.fallingtree.fabric.common.wrapper.ComponentWrapper;
import fr.raksrinana.fallingtree.fabric.common.wrapper.EnchantmentWrapper;
import fr.raksrinana.fallingtree.fabric.common.wrapper.ItemWrapper;
import fr.raksrinana.fallingtree.fabric.enchant.ChopperEnchantment;
import fr.raksrinana.fallingtree.fabric.event.BlockBreakListener;
import fr.raksrinana.fallingtree.fabric.event.LeafBreakingListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class FallingTreeCommonsImpl
extends FallingTreeCommon<class_2350> {
    private final LeafBreakingHandler leafBreakingHandler = new LeafBreakingHandler(this);
    private Collection<IEnchantment> chopperEnchantments = new ArrayList<IEnchantment>();

    @Override
    @NotNull
    public IComponent translate(@NotNull String key, Object ... objects) {
        return new ComponentWrapper((class_5250)new class_2588(key, objects));
    }

    @Override
    @NotNull
    public Stream<IBlock> getBlock(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            class_2960 identifier = new class_2960(name);
            if (isTag) {
                class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)identifier);
                return this.getRegistryTagContent((class_2378)class_2378.field_11146, (class_6862)tag).map(BlockWrapper::new);
            }
            return Stream.of((class_2248)class_2378.field_11146.method_10223(identifier)).map(BlockWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    @NotNull
    public Stream<IItem> getItem(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            class_2960 identifier = new class_2960(name);
            if (isTag) {
                class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)identifier);
                return this.getRegistryTagContent((class_2378)class_2378.field_11142, (class_6862)tag).map(ItemWrapper::new);
            }
            return Stream.of((class_1792)class_2378.field_11142.method_10223(identifier)).map(ItemWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public boolean isLeafBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = this.registryTagContains((class_2378)class_2378.field_11146, (class_6862)class_3481.field_15503, (Object)((class_2248)block.getRaw())) || this.getConfiguration().getTrees().getAllowedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    public boolean isLogBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = this.getConfiguration().getTrees().getDefaultLogsBlocks(this).stream().anyMatch(log -> log.equals(block)) || this.getConfiguration().getTrees().getAllowedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<IBlock> getAllNonStrippedLogsBlocks() {
        return this.getRegistryTagContent((class_2378)class_2378.field_11146, (class_6862)class_3481.field_15475).filter(block -> Optional.of(class_2378.field_11146.method_10221(block)).map(class_2960::method_12832).map(name -> name.startsWith("stripped")).orElse(false) == false).map(BlockWrapper::new).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public DirectionCompat asDirectionCompat(@NotNull class_2350 dir) {
        return DirectionCompat.valueOf(dir.name());
    }

    @Override
    @NotNull
    public class_2350 asDirection(@NotNull DirectionCompat dir) {
        return class_2350.valueOf((String)dir.name());
    }

    @Override
    public boolean isNetherWartOrShroomlight(@NotNull IBlock block) {
        return this.registryTagContains((class_2378)class_2378.field_11146, (class_6862)class_3481.field_21954, (Object)((class_2248)block.getRaw())) || class_2246.field_22122.equals(block.getRaw());
    }

    @Override
    public boolean checkCanBreakBlock(@NotNull ILevel level, @NotNull IBlockPos blockPos, @NotNull IBlockState blockState, @NotNull IPlayer player) {
        return true;
    }

    @Override
    protected void performDefaultEnchantRegister() {
        this.chopperEnchantments.add(new EnchantmentWrapper((class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("fallingtree", "chopper"), (Object)new ChopperEnchantment(this, null))));
    }

    @Override
    protected void performSpecificEnchantRegister() {
        this.chopperEnchantments.add(new EnchantmentWrapper((class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("fallingtree", "chopper_instantaneous"), (Object)new ChopperEnchantment(this, BreakMode.INSTANTANEOUS))));
        this.chopperEnchantments.add(new EnchantmentWrapper((class_1887)class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("fallingtree", "chopper_shift_down"), (Object)new ChopperEnchantment(this, BreakMode.SHIFT_DOWN))));
    }

    @Override
    protected void performCommitEnchantRegister() {
    }

    @NotNull
    private <T> Stream<T> getRegistryTagContent(@NotNull class_2378<T> registry, @NotNull class_6862<T> tag) {
        return registry.method_40266(tag).stream().flatMap(a -> a.method_40239().map(class_6880::comp_349));
    }

    private <T> boolean registryTagContains(@NotNull class_2378<T> registry, @NotNull class_6862<T> tag, @NotNull T element) {
        return this.getRegistryTagContent(registry, tag).anyMatch(element::equals);
    }

    public void register() {
        ServerTickEvents.END_SERVER_TICK.register((Object)new LeafBreakingListener(this));
        PlayerBlockBreakEvents.BEFORE.register((Object)new BlockBreakListener(this));
    }

    @Override
    public LeafBreakingHandler getLeafBreakingHandler() {
        return this.leafBreakingHandler;
    }

    @Override
    public Collection<IEnchantment> getChopperEnchantments() {
        return this.chopperEnchantments;
    }
}

