/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.util.BasicRecipeSerializer;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public final class ImpostorRecipe
extends ShapedRecipe {
    private final String group;
    public static final RecipeSerializer<ImpostorRecipe> SERIALIZER = new BasicRecipeSerializer<ImpostorRecipe>(){

        @Nonnull
        public ImpostorRecipe fromJson(@Nonnull ResourceLocation identifier, @Nonnull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(identifier, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new ImpostorRecipe(identifier, group, recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_(), result);
        }

        public ImpostorRecipe fromNetwork(@Nonnull ResourceLocation identifier, @Nonnull FriendlyByteBuf buf) {
            int width = buf.m_130242_();
            int height = buf.m_130242_();
            String group = buf.m_130136_(Short.MAX_VALUE);
            NonNullList items = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < items.size(); ++k) {
                items.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            return new ImpostorRecipe(identifier, group, width, height, (NonNullList<Ingredient>)items, result);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull ImpostorRecipe recipe) {
            buf.m_130130_(recipe.getRecipeWidth());
            buf.m_130130_(recipe.getRecipeHeight());
            buf.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_());
        }
    };

    private ImpostorRecipe(@Nonnull ResourceLocation id, @Nonnull String group, int width, int height, NonNullList<Ingredient> ingredients, @Nonnull ItemStack result) {
        super(id, group, width, height, ingredients, result);
        this.group = group;
    }

    @Nonnull
    public String m_6076_() {
        return this.group;
    }

    public boolean m_5818_(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull CraftingContainer inventory) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

