/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.command.text.TableFormatter;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class ClientTableFormatter
implements TableFormatter {
    public static final ClientTableFormatter INSTANCE = new ClientTableFormatter();
    private static final Int2IntOpenHashMap lastHeights = new Int2IntOpenHashMap();

    private static Font renderer() {
        return Minecraft.m_91087_().f_91062_;
    }

    @Override
    @Nullable
    public Component getPadding(Component component, int width) {
        int extraWidth = width - this.getWidth(component);
        if (extraWidth <= 0) {
            return null;
        }
        Font renderer = ClientTableFormatter.renderer();
        float spaceWidth = renderer.m_92895_(" ");
        int spaces = Mth.m_14143_((float)((float)extraWidth / spaceWidth));
        int extra = extraWidth - (int)((float)spaces * spaceWidth);
        return ChatHelpers.coloured(StringUtils.repeat((char)' ', (int)spaces) + StringUtils.repeat((char)'\u02c8', (int)extra), ChatFormatting.GRAY);
    }

    @Override
    public int getColumnPadding() {
        return 3;
    }

    @Override
    public int getWidth(Component component) {
        return ClientTableFormatter.renderer().m_92852_((FormattedText)component);
    }

    @Override
    public void writeLine(int id, Component component) {
        Minecraft mc = Minecraft.m_91087_();
        ChatComponent chat = mc.f_91065_.m_93076_();
        chat.m_93787_(component, id);
    }

    @Override
    public int display(TableBuilder table) {
        ChatComponent chat = Minecraft.m_91087_().f_91065_.m_93076_();
        int lastHeight = lastHeights.get(table.getId());
        int height = TableFormatter.super.display(table);
        lastHeights.put(table.getId(), height);
        for (int i = height; i < lastHeight; ++i) {
            chat.m_93803_(i + table.getId());
        }
        return height;
    }
}

