/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.play;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.client.SessionData;
import com.mrcrayfish.configured.client.screen.RequestScreen;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import com.mrcrayfish.configured.network.message.MessageResponseSimpleConfig;
import com.mrcrayfish.configured.network.message.MessageSessionData;
import com.mrcrayfish.configured.network.message.MessageSyncForgeConfig;
import com.mrcrayfish.configured.network.message.MessageSyncSimpleConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.network.NetworkEvent;

public class ClientPlayHandler {
    public static void handleSyncServerConfigMessage(NetworkEvent.Context context, MessageSyncForgeConfig message) {
        if (Minecraft.m_91087_().m_91090_()) {
            return;
        }
        Configured.LOGGER.info("Received forge config sync from server");
        ModConfig config = ConfigHelper.getForgeConfig(message.fileName());
        if (config == null) {
            Configured.LOGGER.error("Server sent data for a forge config that doesn't exist: {}", (Object)message.fileName());
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.process_config"));
            return;
        }
        if (config.getType() != ModConfig.Type.SERVER) {
            Configured.LOGGER.error("Server sent data for a config that isn't a server type: {}", (Object)message.fileName());
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.process_config"));
            return;
        }
        try {
            CommentedConfig data = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.data()));
            config.getSpec().acceptConfig(data);
            ConfigHelper.fireForgeConfigEvent(config, (ModConfigEvent)new ModConfigEvent.Reloading(config));
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void handleSyncSimpleConfigMessage(NetworkEvent.Context context, MessageSyncSimpleConfig message) {
        if (Minecraft.m_91087_().m_91090_()) {
            return;
        }
        Configured.LOGGER.debug("Received simple config sync from server");
        SimpleConfigManager.SimpleConfigImpl config = SimpleConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Configured.LOGGER.error("Server sent data for a config that doesn't exist: {}", (Object)message.id());
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.process_config"));
            return;
        }
        if (config.isReadOnly()) {
            Configured.LOGGER.error("Server sent data for a read-only config '{}'. This should not happen!", (Object)message.id());
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.process_config"));
            return;
        }
        if (!config.getType().isSync()) {
            Configured.LOGGER.error("Server sent data for non-sync config '{}'. This should not happen!", (Object)message.id());
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.process_config"));
            return;
        }
        if (!config.isLoaded()) {
            Configured.LOGGER.error("Tried to perform sync update on an unloaded config. Something went wrong...");
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.process_config"));
            return;
        }
        if (!SimpleConfigManager.getInstance().processSyncData(message, false)) {
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.process_config"));
        }
    }

    public static void handleResponseSimpleConfigMessage(MessageResponseSimpleConfig message) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof RequestScreen) {
            RequestScreen screen2 = (RequestScreen)screen;
            SimpleConfigManager.SimpleConfigImpl entry = SimpleConfigManager.getInstance().getConfig(message.id());
            if (entry == null || screen2.getActiveConfig() != entry) {
                screen2.handleResponse(null, (Component)new TranslatableComponent("configured.gui.request.invalid_config"));
                return;
            }
            if (!Minecraft.m_91087_().m_91090_() && !SimpleConfigManager.getInstance().processResponseData(message)) {
                screen2.handleResponse(null, (Component)new TranslatableComponent("configured.gui.request.process_error"));
                return;
            }
            screen2.handleResponse(entry, null);
        }
    }

    public static void handleJoinMessage(MessageSessionData data) {
        SessionData.setDeveloper(data.isDeveloper());
        SessionData.setLan(data.isLan());
    }
}

