/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.config;

import cofh.core.config.IBaseConfig;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.cultivation.item.WateringCanItem;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class TCulToolConfig
implements IBaseConfig {
    private Supplier<Integer> wateringCanCapacity;
    private Supplier<Boolean> wateringCanFakePlayers;
    private Supplier<Boolean> wateringCanSourceBlocks;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Tools");
        builder.push("Watering Can");
        this.wateringCanCapacity = builder.comment("This sets the maximum base fluid capacity for the Watering Can.").defineInRange("Base Capacity", 4000, 1000, 10000000);
        this.wateringCanFakePlayers = builder.comment("If TRUE, the Watering Can can be used by Fake Players.").define("Allow Fake Players", WateringCanItem.allowFakePlayers);
        this.wateringCanSourceBlocks = builder.comment("If TRUE, the Watering Can consumes source blocks when refilling.").define("Consume Source Blocks", WateringCanItem.removeSourceBlocks);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        ((WateringCanItem)ThermalCore.ITEMS.get("watering_can")).setFluidCapacity(this.wateringCanCapacity.get());
        WateringCanItem.allowFakePlayers = this.wateringCanFakePlayers.get();
        WateringCanItem.removeSourceBlocks = this.wateringCanSourceBlocks.get();
    }
}

