/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.peripheral.tape;

import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.NotAttachedException;
import github.shrekshellraiser.cctech.common.item.StorageItem;
import github.shrekshellraiser.cctech.common.item.tape.TapeItem;
import github.shrekshellraiser.cctech.common.peripheral.NoDeviceException;
import github.shrekshellraiser.cctech.common.peripheral.StorageBlockEntity;
import github.shrekshellraiser.cctech.server.FileManager;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TapeBlockEntity
extends StorageBlockEntity {
    protected byte[] data = new byte[2];
    protected int pointer;
    protected String deviceDir;
    protected double ticksPerByte;
    protected ArrayDeque<QueueItem> eventQueue = new ArrayDeque();
    protected QueueState queueState = QueueState.FREE;
    protected QueueItem currentItem;
    protected int timer;

    public TapeBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return null;
    }

    protected void assertReady() throws LuaException {
        if (!this.deviceInserted) {
            throw new NoDeviceException();
        }
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    private MethodResult syncQueue(Object value, String eventName, int ticks, IComputerAccess computerAccess) throws LuaException {
        this.eventQueue.add(new QueueItem(value, eventName, ticks, computerAccess));
        return new EventFinished(eventName).getMethodResult();
    }

    public MethodResult readData(IComputerAccess computerAccess, int amount, boolean async) throws LuaException {
        this.assertReady();
        this.dataChanged = true;
        byte[] chars = new byte[amount];
        try {
            System.arraycopy(this.data, this.pointer + FileManager.POINTER_SIZE, chars, 0, amount);
            this.pointer += amount;
        }
        catch (IndexOutOfBoundsException e) {
            this.pointer = Math.max(this.pointer, 0);
            this.pointer = Math.min(this.pointer, this.data.length - FileManager.POINTER_SIZE);
            throw new LuaException("Attempt to read past tape end.");
        }
        MethodResult event = this.syncQueue(new String(chars, StandardCharsets.ISO_8859_1), "tape_read", (int)(this.ticksPerByte * (double)amount), computerAccess);
        if (async) {
            return MethodResult.of((Object)true);
        }
        return event;
    }

    private void enforcePointer() {
        this.pointer = Math.max(this.pointer, 0);
        this.pointer = Math.min(this.pointer, this.data.length - FileManager.POINTER_SIZE);
    }

    private MethodResult seek(IComputerAccess computerAccess, int distanceMoved, boolean async) throws LuaException {
        MethodResult event = this.syncQueue(distanceMoved, "tape_seek", (int)((double)distanceMoved * this.ticksPerByte), computerAccess);
        if (async) {
            return MethodResult.of((Object)true);
        }
        return event;
    }

    public MethodResult seekRel(IComputerAccess computerAccess, int offset, boolean async) throws LuaException {
        this.assertReady();
        this.dataChanged = true;
        int startingPointer = this.pointer;
        this.pointer += offset;
        this.enforcePointer();
        int distanceMoved = this.pointer - startingPointer;
        return this.seek(computerAccess, distanceMoved, async);
    }

    public MethodResult seekAbs(IComputerAccess computerAccess, int target, boolean async) throws LuaException {
        this.assertReady();
        this.dataChanged = true;
        int oldPos = this.pointer;
        this.pointer = target;
        this.enforcePointer();
        int distanceMoved = this.pointer - oldPos;
        return this.seek(computerAccess, distanceMoved, async);
    }

    public MethodResult write(IComputerAccess computerAccess, String str, boolean async) throws LuaException {
        this.assertReady();
        byte[] chars = str.getBytes(StandardCharsets.ISO_8859_1);
        this.dataChanged = true;
        int maxPointer = this.data.length - FileManager.POINTER_SIZE;
        int endPointer = this.pointer + str.length();
        if (endPointer > maxPointer) {
            int writeAmount = this.pointer - maxPointer;
            System.arraycopy(chars, 0, this.data, this.pointer + FileManager.POINTER_SIZE, writeAmount);
            this.pointer += writeAmount;
            this.eventQueue.add(new QueueItem(false, "tape_write", (int)(this.ticksPerByte * (double)writeAmount), computerAccess));
            if (async) {
                return MethodResult.of((Object)false);
            }
            return new EventFinished("tape_write").getMethodResult();
        }
        System.arraycopy(chars, 0, this.data, this.pointer + FileManager.POINTER_SIZE, str.length());
        this.pointer += str.length();
        MethodResult event = this.syncQueue(true, "tape_write", (int)(this.ticksPerByte * (double)str.length()), computerAccess);
        if (async) {
            return MethodResult.of((Object)true);
        }
        return event;
    }

    public boolean setLabel(String label) throws LuaException {
        this.assertReady();
        ItemStack item = this.itemHandler.getStackInSlot(0);
        ((StorageItem)item.m_41720_()).setLabel(item, label);
        return true;
    }

    public boolean clearLabel() throws LuaException {
        this.assertReady();
        ItemStack item = this.itemHandler.getStackInSlot(0);
        ((StorageItem)item.m_41720_()).removeLabel(item);
        return true;
    }

    public int getSize() throws LuaException {
        this.assertReady();
        return this.data.length - FileManager.POINTER_SIZE;
    }

    @Override
    protected void loadData(ItemStack item) {
        this.uuid = ((StorageItem)item.m_41720_()).getUUID(item);
        this.data = FileManager.getData(this.deviceDir, this.uuid, ((TapeItem)item.m_41720_()).getLength(item) + FileManager.POINTER_SIZE);
        this.pointer = FileManager.getPointer(this.data);
    }

    @Override
    protected void saveData(ItemStack item) {
        FileManager.saveData(this.data, this.pointer, this.deviceDir, this.uuid);
    }

    private static void getItemFromQueue(TapeBlockEntity pBlockEntity) {
        while (!pBlockEntity.eventQueue.isEmpty() && pBlockEntity.queueState == QueueState.FREE) {
            pBlockEntity.currentItem = pBlockEntity.eventQueue.poll();
            pBlockEntity.queueState = QueueState.WAITING;
            pBlockEntity.timer = pBlockEntity.currentItem.ticks;
            if (pBlockEntity.timer != 0) continue;
            QueueItem item = pBlockEntity.currentItem;
            item.computerAccess.queueEvent(item.eventName, new Object[]{item.computerAccess.getAttachmentName(), true, item.returnValue});
            pBlockEntity.queueState = QueueState.FREE;
        }
    }

    private static void tickItem(TapeBlockEntity pBlockEntity) {
        QueueItem item = pBlockEntity.currentItem;
        try {
            item.computerAccess.getAttachmentName();
        }
        catch (NotAttachedException NAE) {
            pBlockEntity.queueState = QueueState.FREE;
            pBlockEntity.currentItem = null;
            return;
        }
        if (pBlockEntity.timer-- <= 0) {
            if (item.assertReady) {
                try {
                    pBlockEntity.assertReady();
                }
                catch (LuaException e) {
                    item.computerAccess.queueEvent(item.eventName, new Object[]{item.computerAccess.getAttachmentName(), false, e.toString()});
                    return;
                }
            }
            pBlockEntity.queueState = QueueState.FREE;
            if (item.assertReady) {
                try {
                    pBlockEntity.assertReady();
                }
                catch (LuaException e) {
                    item.computerAccess.queueEvent(item.eventName, new Object[]{item.computerAccess.getAttachmentName(), false, e.toString()});
                    return;
                }
            }
            item.computerAccess.queueEvent(item.eventName, new Object[]{item.computerAccess.getAttachmentName(), true, item.returnValue});
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, TapeBlockEntity pBlockEntity) {
        if (!pLevel.m_5776_()) {
            switch (pBlockEntity.queueState) {
                case FREE: {
                    TapeBlockEntity.getItemFromQueue(pBlockEntity);
                    break;
                }
                case WAITING: {
                    TapeBlockEntity.tickItem(pBlockEntity);
                }
            }
        }
    }

    protected static enum QueueState {
        FREE,
        WAITING;

    }

    protected static final class QueueItem {
        public final Object returnValue;
        public final String eventName;
        public final boolean assertReady;
        public final int ticks;
        public final IComputerAccess computerAccess;

        QueueItem(Object returnValue, String eventName, int ticks, IComputerAccess computerAccess, boolean assertReady) {
            this.returnValue = returnValue;
            this.eventName = eventName;
            this.ticks = ticks;
            this.computerAccess = computerAccess;
            this.assertReady = assertReady;
        }

        QueueItem(Object returnValue, String eventName, int ticks, IComputerAccess computerAccess) {
            this(returnValue, eventName, ticks, computerAccess, false);
        }
    }

    protected final class EventFinished
    implements ILuaCallback {
        private final String filter;

        public EventFinished(String filter) {
            this.filter = filter;
        }

        public MethodResult getMethodResult() {
            return MethodResult.pullEvent((String)this.filter, (ILuaCallback)this);
        }

        @NotNull
        public MethodResult resume(Object[] args) throws LuaException {
            TapeBlockEntity.this.assertReady();
            if (args.length < 4) {
                throw new LuaException("Invalid amount of arguments for event");
            }
            if (Boolean.valueOf(false).equals(args[2])) {
                throw new LuaException((String)args[3]);
            }
            return MethodResult.of((Object)args[3]);
        }
    }
}

