/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.peripheral.cards;

import dan200.computercraft.api.lua.LuaException;
import github.shrekshellraiser.cctech.common.ModBlockEntities;
import github.shrekshellraiser.cctech.common.ModProperties;
import github.shrekshellraiser.cctech.common.item.cards.MagCardItem;
import github.shrekshellraiser.cctech.common.peripheral.StorageBlockEntity;
import github.shrekshellraiser.cctech.common.peripheral.cards.CardWriterPeripheral;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardWriterBlockEntity
extends StorageBlockEntity {
    private String writerUUID;

    public CardWriterBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.CARD_WRITER.get(), pWorldPosition, pBlockState);
        this.peripheral = new CardWriterPeripheral(this);
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return null;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public boolean setLabel(String label) throws LuaException {
        this.assertReady();
        ItemStack item = this.itemHandler.getStackInSlot(0);
        ((MagCardItem)item.m_41720_()).setLabel(item, label);
        return true;
    }

    public boolean clearLabel() throws LuaException {
        this.assertReady();
        ItemStack item = this.itemHandler.getStackInSlot(0);
        ((MagCardItem)item.m_41720_()).removeLabel(item);
        return true;
    }

    public String getLabel() throws LuaException {
        this.assertReady();
        ItemStack item = this.itemHandler.getStackInSlot(0);
        return ((MagCardItem)item.m_41720_()).getLabel(item);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, CardWriterBlockEntity pBlockEntity) {
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        if (this.writerUUID == null) {
            this.writerUUID = String.valueOf(UUID.randomUUID());
        }
        tag.m_128359_("cctech.uuid", this.writerUUID);
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.writerUUID = nbt.m_128441_("cctech.uuid") ? nbt.m_128461_("cctech.uuid") : String.valueOf(UUID.randomUUID());
    }

    public void onRightClick(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_21205_().m_41720_() instanceof MagCardItem && this.getItem() == Items.f_41852_) {
            this.itemHandler.setStackInSlot(0, pPlayer.m_21205_());
            pPlayer.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
        } else if (pPlayer.m_21205_().m_41720_() == Items.f_41852_) {
            pPlayer.m_8061_(EquipmentSlot.MAINHAND, this.itemHandler.getStackInSlot(0));
            this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_41852_));
        }
    }

    private void assertReady() throws LuaException {
        BlockState state = this.m_58900_();
        if (((Boolean)state.m_61143_((Property)ModProperties.OPEN)).booleanValue()) {
            throw new LuaException("Door open");
        }
        if (!(this.getItem() instanceof MagCardItem)) {
            throw new LuaException("No card inserted");
        }
    }

    public void writeCard(String contents) throws LuaException {
        this.assertReady();
        MagCardItem item = (MagCardItem)this.getItem();
        ItemStack stack = this.getRenderStack();
        item.setContents(stack, contents);
        item.setUUID(stack, this.writerUUID);
    }

    public HashMap<String, String> readCard() throws LuaException {
        this.assertReady();
        HashMap<String, String> map = new HashMap<String, String>();
        MagCardItem item = (MagCardItem)this.getItem();
        ItemStack stack = this.getRenderStack();
        String uuid = item.getUUID(stack);
        String contents = item.getContents(stack);
        map.put("uuid", uuid);
        map.put("contents", contents);
        if (uuid != null && contents != null) {
            return map;
        }
        return null;
    }

    public String getUUID() {
        return this.writerUUID;
    }
}

