/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CCTechCommonConfigs {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> CASSETTE_BYTES_PER_SECOND;
    public static final ForgeConfigSpec.ConfigValue<Integer> IRON_CASSETTE;
    public static final ForgeConfigSpec.ConfigValue<Integer> GOLD_CASSETTE;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIAMOND_CASSETTE;
    public static final ForgeConfigSpec.ConfigValue<Integer> CREATIVE_CASSETTE;
    public static final ForgeConfigSpec.ConfigValue<Integer> REEL_BYTES_PER_SECOND;
    public static final ForgeConfigSpec.ConfigValue<Integer> IRON_REEL;
    public static final ForgeConfigSpec.ConfigValue<Integer> GOLD_REEL;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIAMOND_REEL;
    public static final ForgeConfigSpec.ConfigValue<Integer> CREATIVE_REEL;
    public static final ForgeConfigSpec.ConfigValue<Integer> CASSETTE_DEFAULT;
    public static final ForgeConfigSpec.ConfigValue<Integer> TAPE_SIZE;

    static {
        int MAX_SIZE = Integer.MAX_VALUE;
        BUILDER.push("CCTech Config");
        CASSETTE_BYTES_PER_SECOND = BUILDER.defineInRange("Cassette Operation Time (Bps): ", 10000, 1, Integer.MAX_VALUE);
        IRON_CASSETTE = BUILDER.defineInRange("Iron Cassette Size", 720000, 1, Integer.MAX_VALUE);
        GOLD_CASSETTE = BUILDER.defineInRange("Gold Cassette Size", 1440000, 1, Integer.MAX_VALUE);
        DIAMOND_CASSETTE = BUILDER.defineInRange("Diamond Cassette Size", 2880000, 1, Integer.MAX_VALUE);
        CREATIVE_CASSETTE = BUILDER.defineInRange("Creative Cassette Size", 21600000, 1, Integer.MAX_VALUE);
        CASSETTE_DEFAULT = BUILDER.defineInRange("Cassette Default Size", 360000, 1, Integer.MAX_VALUE);
        TAPE_SIZE = BUILDER.defineInRange("Magnetic Tape Size", 60000, 1, Integer.MAX_VALUE);
        REEL_BYTES_PER_SECOND = BUILDER.defineInRange("Reel Operation Time (Bps): ", 20000, 1, Integer.MAX_VALUE);
        IRON_REEL = BUILDER.defineInRange("Iron Reel Size", 1440000, 1, Integer.MAX_VALUE);
        GOLD_REEL = BUILDER.defineInRange("Gold Reel Size", 2880000, 1, Integer.MAX_VALUE);
        DIAMOND_REEL = BUILDER.defineInRange("Diamond Reel Size", 5760000, 1, Integer.MAX_VALUE);
        CREATIVE_REEL = BUILDER.defineInRange("Creative Reel Size", 46080000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

