/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.util;

import cofh.core.compat.curios.CuriosProxy;
import cofh.core.util.ProxyUtils;
import cofh.lib.util.helpers.MathHelper;
import cofh.redstonearsenal.capability.CapabilityFluxShielding;
import cofh.redstonearsenal.init.RSASounds;
import cofh.redstonearsenal.network.client.FluxShieldingPacket;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class FluxShieldingHelper {
    public static final String TAG_FLUX_SHIELD = "FluxShield";
    public static int currentCharges = 0;
    public static int maximumCharges = 0;

    public static ItemStack findShieldedItem(LivingEntity entity) {
        Predicate<ItemStack> isShieldedItem = i -> i.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY).map(cap -> cap.currCharges(entity) > 0).orElse(false);
        for (ItemStack piece : entity.m_6168_()) {
            if (!isShieldedItem.test(piece)) continue;
            return piece;
        }
        ItemStack[] retStack = new ItemStack[]{ItemStack.f_41583_};
        CuriosProxy.getAllWorn((LivingEntity)entity).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ItemStack slot = c.getStackInSlot(i);
                if (!isShieldedItem.test(slot)) continue;
                retStack[0] = slot;
                return;
            }
        });
        return retStack[0];
    }

    public static int[] countCharges(LivingEntity entity) {
        int[] counter = new int[]{0, 0};
        if (entity == null) {
            return counter;
        }
        Consumer<ItemStack> count = i -> {
            counter[0] = counter[0] + FluxShieldingHelper.getCurrCharges(entity, i);
            counter[1] = counter[1] + FluxShieldingHelper.getMaxCharges(entity, i);
        };
        for (ItemStack item : entity.m_6168_()) {
            count.accept(item);
        }
        CuriosProxy.getAllWorn((LivingEntity)entity).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                count.accept(c.getStackInSlot(i));
            }
        });
        return counter;
    }

    public static boolean hasFluxShieldCharge(LivingEntity entity) {
        return !FluxShieldingHelper.findShieldedItem(entity).m_41619_();
    }

    public static boolean useFluxShieldCharge(LivingEntity entity) {
        return FluxShieldingHelper.useFluxShieldCharge(entity, FluxShieldingHelper.findShieldedItem(entity));
    }

    public static boolean useFluxShieldCharge(LivingEntity entity, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        LazyOptional cap = stack.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY);
        if (cap.map(c -> c.useCharge(entity)).orElse(false).booleanValue()) {
            FluxShieldingHelper.onUseFluxShieldCharge(entity);
            return true;
        }
        return false;
    }

    public static int getCurrCharges(LivingEntity entity, ItemStack stack) {
        return stack.m_41619_() ? 0 : stack.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY).map(cap -> cap.currCharges(entity)).orElse(0);
    }

    public static int getMaxCharges(LivingEntity entity, ItemStack stack) {
        return stack.m_41619_() ? 0 : stack.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY).map(cap -> cap.maxCharges(entity)).orElse(0);
    }

    public static boolean equalCharges(LivingEntity entity, ItemStack a, ItemStack b) {
        return FluxShieldingHelper.getCurrCharges(entity, a) == FluxShieldingHelper.getCurrCharges(entity, b) && FluxShieldingHelper.getMaxCharges(entity, a) == FluxShieldingHelper.getMaxCharges(entity, b);
    }

    protected static void onUseFluxShieldCharge(LivingEntity entity) {
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)RSASounds.SOUND_SHIELDING_BREAK.get(), entity.m_5720_(), 1.5f, 0.65f + MathHelper.RANDOM.nextFloat(0.2f));
        AABB bounds = entity.m_142469_();
        Vec3 pos = bounds.m_82399_();
        if (!entity.f_19853_.f_46443_) {
            ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 20, bounds.m_82362_() * 0.5 + 0.2, bounds.m_82376_() * 0.5 + 0.2, bounds.m_82385_() * 0.5 + 0.2, 0.0);
        }
    }

    public static void updateHUD(int currCharges, int maxCharges) {
        Player player = ProxyUtils.getClientPlayer();
        Level level = ProxyUtils.getClientWorld();
        if (maxCharges - currCharges < maximumCharges - currentCharges && level != null && player != null) {
            level.m_6269_(player, (Entity)player, (SoundEvent)RSASounds.SOUND_SHIELDING_RECHARGE.get(), SoundSource.PLAYERS, 0.75f, 0.3f * (float)currCharges / (float)maxCharges + 0.7f);
        }
        currentCharges = currCharges;
        maximumCharges = maxCharges;
    }

    public static void updateHUD(int[] charges) {
        FluxShieldingHelper.updateHUD(charges[0], charges[1]);
    }

    public static void updateHUD(Player player) {
        FluxShieldingHelper.updateHUD(FluxShieldingHelper.countCharges((LivingEntity)player));
    }

    public static void updateHUD(ServerPlayer player) {
        FluxShieldingPacket.sendToClient(FluxShieldingHelper.countCharges((LivingEntity)player), player);
    }
}

