/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.entity;

import cofh.lib.util.helpers.MathHelper;
import cofh.redstonearsenal.init.RSAEntities;
import cofh.redstonearsenal.item.IFluxItem;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FluxArrow
extends AbstractArrow {
    protected static final EntityDataAccessor<Byte> RSA_FLAGS = SynchedEntityData.m_135353_(FluxArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final int LIFESPAN = 200;
    protected static final float EXPLOSION_RANGE = 4.0f;

    public FluxArrow(EntityType<? extends FluxArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
    }

    public FluxArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)RSAEntities.FLUX_ARROW.get(), shooter, worldIn);
    }

    public FluxArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)RSAEntities.FLUX_ARROW.get(), x, y, z, worldIn);
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void setExplodeArrow(boolean explode) {
        this.setRSAFlag(1, explode);
    }

    public boolean isExplodeArrow() {
        return ((Byte)this.f_19804_.m_135370_(RSA_FLAGS) & 1) != 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RSA_FLAGS, (Object)0);
    }

    private void setRSAFlag(int flag, boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(RSA_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(RSA_FLAGS, (Object)((byte)(b0 | flag)));
        } else {
            this.f_19804_.m_135381_(RSA_FLAGS, (Object)((byte)(b0 & ~flag)));
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public DamageSource getDamageSource(AbstractArrow arrow, @Nullable Entity shooter) {
        return IFluxItem.fluxRangedDamage((Projectile)arrow, (Entity)(shooter == null ? arrow : shooter));
    }

    public void explode(Vec3 pos) {
        if (!this.f_19853_.m_5776_()) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 0.5f, (1.0f + (this.f_19853_.f_46441_.nextFloat() - this.f_19853_.f_46441_.nextFloat()) * 0.2f) * 0.7f);
            double r2 = 16.0;
            AABB searchArea = this.m_142469_().m_82383_(pos.m_82546_(this.m_20182_())).m_82400_(4.0);
            for (Entity target : this.f_19853_.m_6249_((Entity)this, searchArea, EntitySelector.f_20406_)) {
                if (!(pos.m_82557_(target.m_142469_().m_82399_()) < r2)) continue;
                target.m_6469_(this.getDamageSource(this, this.m_37282_()), (float)this.m_36789_());
            }
            this.m_146870_();
        }
    }

    public void m_8119_() {
        if (!this.f_19853_.m_5776_() && this.f_19797_ > 200) {
            this.m_146870_();
        } else {
            super.m_8119_();
        }
    }

    public float getGravity() {
        return this.m_20068_() || this.f_19794_ ? 0.0f : 0.05f;
    }

    public byte m_36796_() {
        return this.isExplodeArrow() ? (byte)0 : super.m_36796_();
    }

    protected float m_6882_() {
        return 0.99f;
    }

    protected void m_6532_(HitResult result) {
        if (this.isExplodeArrow()) {
            this.explode(result.m_82450_());
        } else {
            HitResult.Type type = result.m_6662_();
            if (type == HitResult.Type.ENTITY) {
                this.m_5790_((EntityHitResult)result);
            } else if (type == HitResult.Type.BLOCK) {
                this.m_8060_((BlockHitResult)result);
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target = result.m_82443_();
        float speed = (float)this.m_20184_().m_82553_();
        int dmg = MathHelper.ceil((double)MathHelper.clamp((double)((double)speed * this.f_36698_), (double)0.0, (double)2.147483647E9));
        if (this.m_36796_() > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(target.m_142049_());
        }
        if (this.m_36792_()) {
            dmg = Math.min(this.f_19796_.nextInt(dmg / 2 + 2) + dmg, Integer.MAX_VALUE);
        }
        Entity owner = this.m_37282_();
        DamageSource dmgSource = this.getDamageSource(this, owner);
        if (owner instanceof LivingEntity) {
            ((LivingEntity)owner).m_21335_(target);
        }
        boolean canHurt = this.canHurtEntity(target);
        if (target.m_6469_(dmgSource, (float)dmg)) {
            if (!canHurt) {
                return;
            }
            if (target instanceof LivingEntity) {
                Vec3 vector3d;
                LivingEntity living = (LivingEntity)target;
                if (this.f_36699_ > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_36699_ * 0.6)).m_82556_() > 0.0) {
                    living.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!this.f_19853_.f_46443_ && owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)living, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)living);
                }
                this.m_7761_(living);
                if (living != owner && living instanceof Player && owner instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)owner).f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!target.m_6084_() && this.f_36702_ != null) {
                    this.f_36702_.add(living);
                }
                if (!this.f_19853_.f_46443_ && owner instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)owner;
                    if (this.f_36702_ != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, (Collection)this.f_36702_);
                    } else if (!target.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, Arrays.asList(target));
                    }
                }
            }
            this.m_5496_(this.m_7239_(), 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0) {
                this.m_146870_();
            }
        } else {
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.f_19857_ += 180.0f;
            this.f_19859_ += 180.0f;
            if (!this.f_19853_.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                this.m_146870_();
            }
        }
    }

    protected boolean canHurtEntity(Entity entity) {
        return entity.m_6095_() != EntityType.f_20566_;
    }

    protected void m_8060_(BlockHitResult result) {
        if (this.isExplodeArrow()) {
            this.explode(result.m_82450_());
            return;
        }
        this.f_19853_.m_7605_((Entity)this, (byte)3);
        this.m_146870_();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("explode", this.isExplodeArrow());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setExplodeArrow(nbt.m_128471_("explode"));
    }
}

