/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.common.item.ModItems;

public class TestingUtil {
    public static final String EMPTY_STRUCTURE = "fabric-gametest-api-v1:empty";

    public static void throwPositionedAssertion(GameTestHelper helper, BlockPos relativePos, Supplier<String> msg) {
        throw new GameTestAssertPosException(msg.get(), helper.m_177449_(relativePos), relativePos, helper.m_177436_());
    }

    public static void assertThat(boolean value, Supplier<String> message) {
        if (!value) {
            throw new GameTestAssertException(message.get());
        }
    }

    public static void assertAt(GameTestHelper helper, BlockPos relativePos, boolean value, Supplier<String> message) {
        if (!value) {
            TestingUtil.throwPositionedAssertion(helper, relativePos, message);
        }
    }

    public static void assertEquals(@Nullable Object a, @Nullable Object b) {
        TestingUtil.assertEquals(a, b, () -> "Expected " + a + " to equal " + b);
    }

    public static void assertEquals(@Nullable Object a, @Nullable Object b, Supplier<String> message) {
        TestingUtil.assertThat(Objects.equals(a, b), message);
    }

    public static void assertEqualsAt(GameTestHelper helper, BlockPos relativePos, @Nullable Object a, @Nullable Object b) {
        TestingUtil.assertEqualsAt(helper, relativePos, a, b, () -> "Expected " + a + " to equal " + b);
    }

    public static void assertEqualsAt(GameTestHelper helper, BlockPos relativePos, @Nullable Object a, @Nullable Object b, Supplier<String> message) {
        TestingUtil.assertAt(helper, relativePos, Objects.equals(a, b), message);
    }

    public static <T extends BlockEntity> T assertBlockEntity(GameTestHelper helper, BlockPos relativePos, BlockEntityType<T> type) {
        BlockEntity be = helper.m_177347_(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected BlockEntity of type " + Registry.f_122830_.m_7981_((Object)type) + " but found no BlockEntity");
        TestingUtil.assertAt(helper, relativePos, be.m_58903_() == type, () -> "Expected BlockEntity of type " + Registry.f_122830_.m_7981_((Object)type) + " but found " + Registry.f_122830_.m_7981_((Object)be.m_58903_()));
        return (T)be;
    }

    public static <T extends BlockEntity> T assertBlockEntity(GameTestHelper helper, BlockPos relativePos, Class<T> classs) {
        BlockEntity be = helper.m_177347_(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected BlockEntity of class " + classs.getSimpleName() + " but found no BlockEntity");
        TestingUtil.assertAt(helper, relativePos, classs.isAssignableFrom(be.getClass()), () -> "Expected BlockEntity to be an instance of " + classs.getSimpleName() + " but found " + be.getClass().getSimpleName());
        return (T)be;
    }

    public static BlockEntity assertAnyBlockEntity(GameTestHelper helper, BlockPos relativePos) {
        BlockEntity be = helper.m_177347_(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected any BlockEntity but found nothing");
        return be;
    }

    public static void useItemOn(GameTestHelper helper, Player player, InteractionHand hand, BlockPos pos) {
        BlockPos absolutePos = helper.m_177449_(pos);
        BlockHitResult result = new BlockHitResult(Vec3.m_82512_((Vec3i)absolutePos), Direction.NORTH, absolutePos, true);
        ItemStack stack = player.m_21120_(hand);
        UseOnContext useOnContext = new UseOnContext(player, hand, result);
        stack.m_41661_(useOnContext);
    }

    public static void bindWithWandOfTheForest(GameTestHelper helper, BlockPos first, BlockPos second) {
        Player player = helper.m_177368_();
        player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ModItems.twigWand));
        player.m_20260_(true);
        player.m_146884_(Vec3.m_82512_((Vec3i)first));
        TestingUtil.useItemOn(helper, player, InteractionHand.MAIN_HAND, first);
        player.m_146884_(Vec3.m_82512_((Vec3i)second));
        TestingUtil.useItemOn(helper, player, InteractionHand.MAIN_HAND, second);
    }
}

