/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemManaMirror
extends Item {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_BACKLOG = "manaBacklog";
    private static final String TAG_POS = "pos";
    private static final DummyPool fallbackPool = new DummyPool();

    public ItemManaMirror(Item.Properties props) {
        super(props);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int m_142159_(ItemStack stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        return Mth.m_14169_((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.f_46443_) {
            return;
        }
        IManaPool pool = this.getManaPool(world.m_142572_(), stack);
        if (!(pool instanceof DummyPool)) {
            if (pool == null) {
                ItemManaMirror.setMana(stack, 0);
            } else {
                pool.receiveMana(ItemManaMirror.getManaBacklog(stack));
                ItemManaMirror.setManaBacklog(stack, 0);
                ItemManaMirror.setMana(stack, pool.getCurrentMana());
            }
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        IManaReceiver receiver;
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (player != null && player.m_6144_() && !world.f_46443_ && (receiver = IXplatAbstractions.INSTANCE.findManaReceiver(world, ctx.m_8083_(), null)) instanceof IManaPool) {
            IManaPool pool = (IManaPool)receiver;
            this.bindPool(ctx.m_43722_(), pool);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.ding, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected static void setMana(ItemStack stack, int mana) {
        if (mana > 0) {
            ItemNBTHelper.setInt(stack, TAG_MANA, mana);
        } else {
            ItemNBTHelper.removeEntry(stack, TAG_MANA);
        }
    }

    protected static int getManaBacklog(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
    }

    protected static void setManaBacklog(ItemStack stack, int backlog) {
        ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
    }

    public void bindPool(ItemStack stack, IManaPool pool) {
        GlobalPos pos = GlobalPos.m_122643_((ResourceKey)pool.getManaReceiverLevel().m_46472_(), (BlockPos)pool.getManaReceiverPos());
        Tag ser = (Tag)GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).get().orThrow();
        ItemNBTHelper.set(stack, TAG_POS, ser);
    }

    @Nullable
    private static GlobalPos getBoundPos(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(TAG_POS)) {
            return null;
        }
        return GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)ItemNBTHelper.get(stack, TAG_POS)).result().filter(pos -> pos.m_122646_().m_123342_() != Integer.MIN_VALUE).orElse(null);
    }

    @Nullable
    private IManaPool getManaPool(@Nullable MinecraftServer server, ItemStack stack) {
        IManaReceiver receiver;
        if (server == null) {
            return fallbackPool;
        }
        GlobalPos pos = ItemManaMirror.getBoundPos(stack);
        if (pos == null) {
            return fallbackPool;
        }
        ResourceKey type = pos.m_122640_();
        ServerLevel world = server.m_129880_(type);
        if (world != null && (receiver = IXplatAbstractions.INSTANCE.findManaReceiver((Level)world, pos.m_122646_(), null)) instanceof IManaPool) {
            IManaPool pool = (IManaPool)receiver;
            return pool;
        }
        return null;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    private static class DummyPool
    implements IManaPool {
        private DummyPool() {
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void receiveMana(int mana) {
        }

        @Override
        public boolean canReceiveManaFromBursts() {
            return false;
        }

        @Override
        public Level getManaReceiverLevel() {
            return null;
        }

        @Override
        public BlockPos getManaReceiverPos() {
            return IManaBurst.NO_SOURCE;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public boolean isOutputtingPower() {
            return false;
        }

        @Override
        public DyeColor getColor() {
            return DyeColor.WHITE;
        }

        @Override
        public void setColor(DyeColor color) {
        }
    }

    public static class CoordBoundItem
    implements ICoordBoundItem {
        private final ItemStack stack;

        public CoordBoundItem(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public BlockPos getBinding(Level world) {
            GlobalPos pos = ItemManaMirror.getBoundPos(this.stack);
            if (pos == null) {
                return null;
            }
            if (pos.m_122640_() == world.m_46472_()) {
                return pos.m_122646_();
            }
            return null;
        }
    }

    public static class ManaItem
    implements IManaItem {
        private final ItemStack stack;

        public ManaItem(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            return ItemNBTHelper.getInt(this.stack, ItemManaMirror.TAG_MANA, 0);
        }

        @Override
        public int getMaxMana() {
            return 1000000;
        }

        @Override
        public void addMana(int mana) {
            ItemManaMirror.setMana(this.stack, this.getMana() + mana);
            ItemManaMirror.setManaBacklog(this.stack, ItemManaMirror.getManaBacklog(this.stack) + mana);
        }

        @Override
        public boolean canReceiveManaFromPool(BlockEntity pool) {
            return false;
        }

        @Override
        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return false;
        }

        @Override
        public boolean canExportManaToPool(BlockEntity pool) {
            return false;
        }

        @Override
        public boolean canExportManaToItem(ItemStack otherStack) {
            return true;
        }

        @Override
        public boolean isNoExport() {
            return false;
        }
    }
}

